/*
 * Decompiled with CFR 0.152.
 */
package playerquests.builder.quest.action;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import playerquests.builder.gui.GUIBuilder;
import playerquests.builder.gui.component.GUISlot;
import playerquests.builder.quest.action.QuestAction;
import playerquests.builder.quest.action.condition.ActionCondition;
import playerquests.builder.quest.action.data.ActionTweaks;
import playerquests.builder.quest.action.listener.TakeItemListener;
import playerquests.builder.quest.action.option.ActionOption;
import playerquests.builder.quest.action.option.ItemsOption;
import playerquests.builder.quest.data.LocationData;
import playerquests.builder.quest.data.QuesterData;
import playerquests.builder.quest.data.StagePath;
import playerquests.builder.quest.stage.QuestStage;
import playerquests.product.Quest;
import playerquests.utility.ChatUtils;
import playerquests.utility.serialisable.ItemSerialisable;
import playerquests.utility.singleton.QuestRegistry;

public class TakeItemAction
extends QuestAction<TakeItemAction, TakeItemListener> {
    @Override
    public List<Class<? extends ActionOption>> getOptions() {
        return List.of(ItemsOption.class);
    }

    @Override
    public List<Class<? extends ActionCondition>> getConditionBlocklist() {
        return List.of();
    }

    @Override
    public List<ActionTweaks> getTweaks() {
        return List.of();
    }

    @Override
    public String getName() {
        return "Take Item";
    }

    @Override
    protected void prepare(QuesterData questerData) {
        Player player = questerData.getQuester().getPlayer();
        QuestStage questStage = this.getStage();
        Quest quest = questStage.getQuest();
        String path = new StagePath(questStage, List.of(this)).toString();
        String command = String.format("/action consent %s.%s", quest.getID(), path);
        TextComponent.Builder message = (TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)String.format("The '%s' quest is requesting to take items", quest.getTitle())))).color((TextColor)NamedTextColor.GRAY)).appendNewline();
        ItemsOption itemsOption = this.getData().getOption(ItemsOption.class).get();
        itemsOption.getItems().forEach((item, amount) -> ((TextComponent.Builder)message.append(Component.text((String)String.format("- %s (%d)", item.getName(), amount)).color((TextColor)NamedTextColor.WHITE))).appendNewline());
        ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)message.appendNewline()).append((Component)Component.text((String)"> "))).append(((TextComponent)((TextComponent)Component.text((String)"Click here to proceed").color((TextColor)NamedTextColor.GREEN)).decorate(TextDecoration.UNDERLINED)).clickEvent(ClickEvent.runCommand((String)command)))).build();
        ChatUtils.message(message.asComponent()).player(player).send();
    }

    @Override
    protected boolean isCompleted(QuesterData questerData) {
        if (!questerData.getConsent(this)) {
            return false;
        }
        Player player = questerData.getQuester().getPlayer();
        ItemsOption itemsOption = this.getData().getOption(ItemsOption.class).get();
        return ItemSerialisable.hasRequiredItems(player, itemsOption.getItems());
    }

    @Override
    protected Class<?> getListenerType() {
        return TakeItemListener.class;
    }

    @Override
    protected void success(QuesterData questerData) {
        Player player = questerData.getQuester().getPlayer();
        PlayerInventory playerInventory = player.getInventory();
        ItemsOption itemsOption = this.getData().getOption(ItemsOption.class).get();
        Quest quest = this.getStage().getQuest();
        itemsOption.getItems().forEach((arg_0, arg_1) -> TakeItemAction.lambda$success$1((Inventory)playerInventory, quest, arg_0, arg_1));
        player.sendMessage(String.format("%n<%s>", "Taking item"));
        itemsOption.getItems().forEach((item, amount) -> player.sendMessage(String.format("- %s (%d)", item.getName(), amount)));
        player.sendMessage("");
        questerData.setConsent(this, false);
    }

    @Override
    protected void failure(QuesterData questerData) {
        questerData.stopListener(this);
        this.startListener(questerData);
    }

    @Override
    protected TakeItemListener startListener(QuesterData questerData) {
        return new TakeItemListener(this, questerData);
    }

    @Override
    public GUISlot createSlot(GUIBuilder gui, Integer slot) {
        return new GUISlot(gui, slot).setLabel(this.getName()).setDescription(List.of("Takes items from the ", "quester.")).setItem(Material.FLOWER_POT);
    }

    @Override
    public Optional<String> isValid() {
        if (this.getData().getOption(ItemsOption.class).get().getItems().isEmpty()) {
            return Optional.of("No items are set, try choosing some items in the action options.");
        }
        return Optional.empty();
    }

    @Override
    public LocationData getLocation() {
        return null;
    }

    private static /* synthetic */ void lambda$success$1(Inventory playerInventory, Quest quest, ItemSerialisable itemSerialisable, Integer amount) {
        ItemStack itemStack = itemSerialisable.toItemStack();
        itemStack.setAmount(amount.intValue());
        playerInventory.removeItem(new ItemStack[]{itemStack});
        QuestRegistry.getInstance().updateInventoryItem(quest, Map.of(itemSerialisable, amount));
    }
}

