/*
 * Decompiled with CFR 0.152.
 */
package playerquests.builder.quest.action.condition;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import playerquests.Core;
import playerquests.builder.gui.GUIBuilder;
import playerquests.builder.gui.component.GUISlot;
import playerquests.builder.gui.dynamic.GUIDynamic;
import playerquests.builder.quest.action.QuestAction;
import playerquests.builder.quest.action.condition.CompletionCondition;
import playerquests.builder.quest.action.condition.CraftCondition;
import playerquests.builder.quest.action.condition.IncompletionCondition;
import playerquests.builder.quest.action.condition.SleepCondition;
import playerquests.builder.quest.action.condition.TimeCondition;
import playerquests.builder.quest.data.ActionData;
import playerquests.builder.quest.data.QuesterData;
import playerquests.builder.quest.data.StagePath;
import playerquests.client.ClientDirector;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="condition")
@JsonSubTypes(value={@JsonSubTypes.Type(value=TimeCondition.class, name="Time"), @JsonSubTypes.Type(value=CompletionCondition.class, name="Completion"), @JsonSubTypes.Type(value=IncompletionCondition.class, name="Incompletion"), @JsonSubTypes.Type(value=CraftCondition.class, name="Craft"), @JsonSubTypes.Type(value=SleepCondition.class, name="Sleep")})
public abstract class ActionCondition {
    @JsonBackReference
    protected ActionData actionData;

    protected ActionCondition() {
    }

    protected ActionCondition(ActionData actionData) {
        this.actionData = actionData;
    }

    public abstract boolean isMet(QuesterData var1);

    public abstract GUISlot createSlot(GUIDynamic var1, GUIBuilder var2, Integer var3, ClientDirector var4);

    @JsonIgnore
    public abstract String getName();

    public abstract void createEditorGUI(GUIDynamic var1, GUIBuilder var2, ClientDirector var3);

    @JsonIgnore
    public abstract List<String> getDetails();

    @JsonIgnore
    public abstract List<String> getDescription();

    @JsonIgnore
    public ActionData getActionData() {
        return this.actionData;
    }

    @JsonIgnore
    public abstract void startListener(QuesterData var1);

    public abstract void cleanUp(QuesterData var1, ActionData var2);

    abstract class ActionConditionListener<C extends ActionCondition>
    implements Listener {
        protected final C actionCondition;
        protected final QuesterData questerData;

        /*
         * WARNING - Possible parameter corruption
         */
        protected ActionConditionListener(C actionCondition, QuesterData questerData) {
            this.actionCondition = actionCondition;
            this.questerData = questerData;
            Bukkit.getPluginManager().registerEvents((Listener)this, Core.getPlugin());
        }

        public void trigger() {
            this.trigger(false);
        }

        public void trigger(boolean preserveListener) {
            QuestAction<?, ?> action = ((ActionCondition)this.actionCondition).getActionData().getAction();
            this.questerData.getQuester().start(List.of(new StagePath(action.getStage(), List.of(action))), action.getStage().getQuest());
            if (!preserveListener) {
                this.close();
            }
        }

        public void close() {
            HandlerList.unregisterAll((Listener)this);
        }
    }
}

