/*
 * Decompiled with CFR 0.152.
 */
package playerquests.builder.quest.action.condition;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.event.EventHandler;
import playerquests.Core;
import playerquests.builder.gui.GUIBuilder;
import playerquests.builder.gui.component.GUISlot;
import playerquests.builder.gui.dynamic.Dynamicactionselector;
import playerquests.builder.gui.dynamic.GUIDynamic;
import playerquests.builder.gui.function.UpdateScreen;
import playerquests.builder.quest.action.QuestAction;
import playerquests.builder.quest.action.condition.ActionCondition;
import playerquests.builder.quest.data.ActionData;
import playerquests.builder.quest.data.QuesterData;
import playerquests.builder.quest.data.StagePath;
import playerquests.builder.quest.stage.QuestStage;
import playerquests.client.ClientDirector;
import playerquests.product.Quest;
import playerquests.utility.ChatUtils;
import playerquests.utility.event.ActionCompletionEvent;

public class CompletionCondition
extends ActionCondition {
    @JsonProperty(value="actions")
    Map<String, List<StagePath>> requiredActions = new HashMap<String, List<StagePath>>();

    public CompletionCondition() {
    }

    public CompletionCondition(ActionData actionData) {
        super(actionData);
    }

    @Override
    public boolean isMet(QuesterData questerData) {
        return this.getRequiredActions().entrySet().stream().allMatch(entry -> {
            Quest quest = Core.getQuestRegistry().getQuest((String)entry.getKey());
            return ((List)entry.getValue()).stream().flatMap(path -> path.getActions(quest).stream()).allMatch(action -> questerData.getQuester().getDiary().getActionCompletionState(quest, (QuestAction<?, ?>)action) == 1);
        });
    }

    public Map<String, List<StagePath>> getRequiredActions() {
        return this.requiredActions;
    }

    @Override
    public GUISlot createSlot(GUIDynamic screen, GUIBuilder gui, Integer slot, ClientDirector director) {
        return new GUISlot(gui, slot).setLabel("Action Requirement").setItem(Material.DETECTOR_RAIL);
    }

    @Override
    public String getName() {
        return "Completion";
    }

    @Override
    public void createEditorGUI(GUIDynamic screen, GUIBuilder gui, ClientDirector director) {
        new GUISlot(gui, 3).setLabel("Select actions").setDescription(List.of("The actions required ", "before starting this action.")).setItem(Material.CHEST).onClick(() -> {
            Quest quest = (Quest)director.getCurrentInstance(Quest.class);
            director.removeCurrentInstance(QuestStage.class);
            director.setCurrentInstance(this.getRequiredActions().getOrDefault(quest.getID(), List.of()), List.class);
            new UpdateScreen(List.of("actionselector"), director).onFinish(f -> {
                UpdateScreen function = (UpdateScreen)f;
                function.getDynamicGUI().onFinish(g -> {
                    Dynamicactionselector actionSelector = (Dynamicactionselector)g;
                    this.setRequiredActions(Map.of(quest.getID(), actionSelector.getSelectedActions()));
                    director.removeCurrentInstance(CompletionCondition.class);
                    director.setCurrentInstance(this.getActionData().getAction().getStage(), QuestStage.class);
                });
            }).execute();
        });
    }

    private void setRequiredActions(Map<String, List<StagePath>> requiredActions) {
        this.requiredActions = requiredActions;
    }

    @Override
    public List<String> getDetails() {
        List<String> actions = this.requiredActions.values().stream().flatMap(Collection::stream).map(StagePath::toString).toList();
        String actionsString = String.join((CharSequence)", ", actions);
        return List.of("Requires", String.format("%s", ChatUtils.shortenString(actionsString, 22)), "to complete");
    }

    @Override
    public List<String> getDescription() {
        return List.of("Set actions required before", "this action can be played");
    }

    @Override
    public void startListener(QuesterData questerData) {
        new CompletionConditionListener(this, this, questerData);
    }

    @Override
    public void cleanUp(QuesterData questerData, ActionData actionData) {
    }

    class CompletionConditionListener
    extends ActionCondition.ActionConditionListener<CompletionCondition> {
        public CompletionConditionListener(CompletionCondition this$0, CompletionCondition actionCondition, QuesterData questerData) {
            super((ActionCondition)this$0, (ActionCondition)actionCondition, questerData);
        }

        @EventHandler
        private void onActionCompletion(ActionCompletionEvent event) {
            if (!event.getQuesterData().getQuester().equals(this.questerData.getQuester())) {
                return;
            }
            if (!((CompletionCondition)this.actionCondition).isMet(this.questerData)) {
                return;
            }
            this.trigger();
        }
    }
}

