/*
 * Decompiled with CFR 0.152.
 */
package playerquests.builder.quest.action.condition;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import playerquests.Core;
import playerquests.builder.gui.GUIBuilder;
import playerquests.builder.gui.component.GUISlot;
import playerquests.builder.gui.dynamic.GUIDynamic;
import playerquests.builder.gui.function.ChatPrompt;
import playerquests.builder.quest.action.condition.ActionCondition;
import playerquests.builder.quest.data.ActionData;
import playerquests.builder.quest.data.QuesterData;
import playerquests.client.ClientDirector;

public class TimeCondition
extends ActionCondition {
    @JsonProperty(value="start")
    private long startTime;
    @JsonProperty(value="end")
    private long endTime;

    public TimeCondition() {
    }

    public TimeCondition(ActionData actionData) {
        super(actionData);
    }

    @Override
    public boolean isMet(QuesterData questerData) {
        long worldTime = questerData.getQuester().getPlayer().getWorld().getTime();
        return worldTime >= this.getStartTime() && worldTime <= this.getEndTime();
    }

    @Override
    public GUISlot createSlot(GUIDynamic screen, GUIBuilder gui, Integer slot, ClientDirector director) {
        return new GUISlot(gui, slot).setLabel("Time").setItem(Material.CLOCK);
    }

    @Override
    public String getName() {
        return "Time";
    }

    @Override
    public void createEditorGUI(GUIDynamic screen, GUIBuilder gui, ClientDirector director) {
        new GUISlot(gui, 3).setLabel(String.format("Set start time (%s)", this.startTime)).setDescription(List.of("Action can only be played after this time.")).setItem(Material.PACKED_ICE).onClick(() -> new ChatPrompt(List.of("Set the start time (0 is 6am, 13000 is 6pm, 24000 is 6am).", "none"), director).onFinish(f -> {
            ChatPrompt chatPrompt = (ChatPrompt)f;
            this.setStartTime(Long.parseLong(chatPrompt.getResponse()));
            screen.refresh();
        }).execute());
        new GUISlot(gui, 4).setLabel(String.format("Set end time (%s)", this.endTime)).setDescription(List.of("Action can only be played before this time.")).setItem(Material.WATER_BUCKET).onClick(() -> new ChatPrompt(List.of("Set the end time (0 is 6am, 13000 is 6pm, 24000 is 6am).", "none"), director).onFinish(f -> {
            ChatPrompt chatPrompt = (ChatPrompt)f;
            this.setEndTime(Long.parseLong(chatPrompt.getResponse()));
            screen.refresh();
        }).execute());
    }

    private void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    private long getEndTime() {
        return this.endTime;
    }

    private void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    private long getStartTime() {
        return this.startTime;
    }

    @Override
    public List<String> getDetails() {
        return List.of(String.format("%s to %s", this.startTime, this.endTime));
    }

    @Override
    public List<String> getDescription() {
        return List.of("Set the time of day", "this action can be played");
    }

    @Override
    public void startListener(QuesterData questerData) {
        new TimeConditionListener(this, this, questerData);
    }

    @Override
    public void cleanUp(QuesterData questerData, ActionData actionData) {
    }

    public class TimeConditionListener
    extends ActionCondition.ActionConditionListener<TimeCondition> {
        public TimeConditionListener(TimeCondition this$0, TimeCondition actionCondition, QuesterData questerData) {
            super((ActionCondition)this$0, (ActionCondition)actionCondition, questerData);
            this.timeCheck();
        }

        public void timeCheck() {
            if (((TimeCondition)this.actionCondition).isMet(this.questerData)) {
                this.trigger();
                return;
            }
            Bukkit.getScheduler().runTaskLater(Core.getPlugin(), this::timeCheck, 100L);
        }
    }
}

