/*
 * Decompiled with CFR 0.152.
 */
package playerquests.builder.quest.action.listener;

import org.bukkit.Bukkit;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import playerquests.Core;
import playerquests.builder.quest.action.WalkAction;
import playerquests.builder.quest.action.listener.ActionListener;
import playerquests.builder.quest.data.QuesterData;

public class WalkActionListener
extends ActionListener<WalkAction> {
    private BukkitTask checkTask;
    private static final long CHECK_INTERVAL = 60L;

    public WalkActionListener(WalkAction action, QuesterData questerData) {
        super(action, questerData);
        this.autoTrigger(questerData);
        this.intervalCheck(questerData);
    }

    private void intervalCheck(QuesterData questerData) {
        Plugin plugin = Core.getPlugin();
        this.checkTask = Bukkit.getScheduler().runTaskTimer(plugin, () -> ((WalkAction)this.action).check(questerData), 60L, 60L);
    }

    @Override
    public void close() {
        HandlerList.unregisterAll((Listener)this);
        if (this.checkTask != null && !this.checkTask.isCancelled()) {
            this.checkTask.cancel();
        }
    }
}

