/*
 * Decompiled with CFR 0.152.
 */
package playerquests.builder.quest.action.option;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bukkit.Material;
import playerquests.builder.gui.GUIBuilder;
import playerquests.builder.gui.component.GUISlot;
import playerquests.builder.gui.dynamic.GUIDynamic;
import playerquests.builder.gui.function.ChatPrompt;
import playerquests.builder.quest.action.option.ActionOption;
import playerquests.builder.quest.data.ActionData;
import playerquests.client.ClientDirector;
import playerquests.utility.ChatUtils;

public class DialogueOption
extends ActionOption {
    @JsonProperty(value="text")
    List<String> text = new ArrayList<String>();

    public DialogueOption() {
    }

    public DialogueOption(ActionData actionData) {
        super(actionData);
    }

    @Override
    public synchronized GUISlot createSlot(GUIDynamic screen, GUIBuilder gui, Integer slot, ClientDirector director) {
        String joinedText = String.join((CharSequence)", ", this.getText());
        String shortenedText = String.format("%s", ChatUtils.shortenString(joinedText, 8));
        return new GUISlot(gui, slot).setLabel(this.text.isEmpty() ? "Set the Dialogue" : String.format("Change the Dialogue (%s)", shortenedText)).setItem(Material.OAK_SIGN).onClick(() -> new ChatPrompt(List.of("Enter dialogue", "none"), director).onFinish(f -> {
            ChatPrompt function = (ChatPrompt)f;
            String response = function.getResponse();
            this.setText(List.of(response));
            this.actionData.setOption(this);
            screen.refresh();
        }).execute());
    }

    public void setText(List<String> text) {
        this.text = text;
    }

    public List<String> getText() {
        return this.text;
    }

    @Override
    public Optional<String> isValid() {
        if (this.getText().isEmpty()) {
            return Optional.of("Dialogue is missing, try setting the action's dialogue in the options menu.");
        }
        return Optional.empty();
    }
}

