/*
 * Decompiled with CFR 0.152.
 */
package playerquests.builder.quest.action.option;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import playerquests.Core;
import playerquests.builder.gui.GUIBuilder;
import playerquests.builder.gui.component.GUISlot;
import playerquests.builder.gui.dynamic.Dynamicselectnpc;
import playerquests.builder.gui.dynamic.GUIDynamic;
import playerquests.builder.gui.function.UpdateScreen;
import playerquests.builder.quest.action.option.ActionOption;
import playerquests.builder.quest.data.ActionData;
import playerquests.builder.quest.npc.QuestNPC;
import playerquests.client.ClientDirector;
import playerquests.product.Quest;

public class NPCOption
extends ActionOption {
    @JsonProperty(value="npc_id")
    String npcID;

    public NPCOption() {
    }

    public NPCOption(ActionData actionData) {
        super(actionData);
    }

    @Override
    public GUISlot createSlot(GUIDynamic screen, GUIBuilder gui, Integer slot, ClientDirector director) {
        Map<String, QuestNPC> npcMap = this.getActionData().getAction().getStage().getQuest().getNPCs();
        return new GUISlot(gui, slot).setLabel(this.npcID == null ? "Set the NPC" : String.format("Change the NPC (%s)", npcMap.get(this.npcID).getName())).setItem(Material.VILLAGER_SPAWN_EGG).onClick(() -> new UpdateScreen(List.of("selectnpc"), director).onFinish(f -> {
            UpdateScreen updateScreen = (UpdateScreen)f;
            Dynamicselectnpc selectNPC = (Dynamicselectnpc)updateScreen.getDynamicGUI();
            Bukkit.getScheduler().runTask(Core.getPlugin(), () -> {
                selectNPC.onSelect(npc -> {
                    this.setNPC(npc.getID());
                    this.actionData.setOption(this);
                });
                selectNPC.onFinish(g -> screen.refresh());
            });
        }).execute());
    }

    public void setNPC(String id) {
        this.npcID = id;
    }

    @JsonIgnore
    public String getNPC() {
        return this.npcID;
    }

    public QuestNPC getNPC(Quest quest) {
        return quest.getNPCs().get(this.getNPC());
    }

    @Override
    public Optional<String> isValid() {
        if (this.getNPC() == null || this.getNPC().isEmpty()) {
            return Optional.of("NPC is missing, try choosing an NPC in the options menu.");
        }
        return Optional.empty();
    }
}

