/*
 * Decompiled with CFR 0.152.
 */
package playerquests.builder.quest.data;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import playerquests.builder.quest.action.QuestAction;
import playerquests.builder.quest.action.condition.ActionCondition;
import playerquests.builder.quest.action.option.ActionOption;
import playerquests.builder.quest.data.StagePath;

public class ActionData {
    @JsonBackReference
    private QuestAction<?, ?> action;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="next")
    private List<StagePath> nextActions = new ArrayList<StagePath>();
    @JsonProperty(value="options")
    @JsonManagedReference
    private List<ActionOption> options = new ArrayList<ActionOption>();
    @JsonProperty(value="conditions")
    @JsonManagedReference
    private List<ActionCondition> conditions;

    public ActionData() {
    }

    public ActionData(QuestAction<?, ?> action, String id, List<StagePath> nextActions, List<ActionCondition> conditions) {
        this.action = action;
        this.id = id;
        this.nextActions = nextActions;
        this.conditions = conditions;
    }

    public List<StagePath> getNextActions() {
        if (this.nextActions == null) {
            return List.of();
        }
        return this.nextActions;
    }

    public void addNextAction(StagePath path) {
        this.nextActions.add(path);
    }

    public void setNextActions(List<StagePath> nextActions) {
        if (nextActions == null) {
            return;
        }
        this.nextActions = nextActions;
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getID() {
        return this.id;
    }

    @JsonProperty(value="options")
    private void setOptions(List<ActionOption> options) {
        if (options == null) {
            this.options = List.of();
            return;
        }
        this.options = options;
    }

    public List<ActionOption> getOptions() {
        return this.getAction().getOptions().stream().map(clazz -> {
            Optional<ActionOption> existingOption = this.options.stream().filter(option -> clazz.isAssignableFrom(option.getClass())).findFirst();
            if (existingOption.isPresent()) {
                return existingOption.get();
            }
            try {
                return (ActionOption)clazz.getDeclaredConstructor(ActionData.class).newInstance(this);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
                return null;
            }
        }).filter(option -> option != null).toList();
    }

    public <T extends ActionOption> Optional<T> getOption(Class<T> optionType) {
        return this.action.getData().getOptions().stream().filter(optionType::isInstance).map(optionType::cast).findFirst();
    }

    public QuestAction<?, ?> getAction() {
        return this.action;
    }

    public void setOption(ActionOption option) {
        this.options.removeIf(o -> option.getClass().isAssignableFrom(o.getClass()));
        this.options.add(option);
    }

    public List<ActionCondition> getConditions() {
        if (this.conditions == null) {
            this.conditions = new ArrayList<ActionCondition>();
        }
        return this.conditions;
    }

    public Optional<String> removeCondition(ActionCondition condition) {
        if (!this.getConditions().remove(condition)) {
            return Optional.of("Could not remove this action");
        }
        return Optional.empty();
    }

    public void addCondition(ActionCondition condition) {
        this.getConditions().add(condition);
    }
}

