/*
 * Decompiled with CFR 0.152.
 */
package playerquests.builder.quest.data;

import org.bukkit.Bukkit;
import org.bukkit.Location;

public class LocationData {
    private String world;
    private double x;
    private double y;
    private double z;
    private float pitch;
    private float yaw;

    public LocationData() {
    }

    public LocationData(String world, double x, double y, double z, float pitch, float yaw) {
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.pitch = pitch;
        this.yaw = yaw;
    }

    public LocationData(LocationData location) {
        this.world = location.getWorld();
        this.x = location.getX();
        this.y = location.getY();
        this.z = location.getZ();
        this.pitch = location.getPitch();
        this.yaw = location.getYaw();
    }

    public LocationData(Location location) {
        this.world = location.getWorld().toString();
        this.x = location.getX();
        this.y = location.getY();
        this.z = location.getZ();
        this.pitch = location.getPitch();
        this.yaw = location.getYaw();
    }

    public String getWorld() {
        return this.world;
    }

    public void setWorld(String world) {
        this.world = world;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getZ() {
        return this.z;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public float getPitch() {
        return this.pitch;
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
    }

    public float getYaw() {
        return this.yaw;
    }

    public void setYaw(float yaw) {
        this.yaw = yaw;
    }

    public String toString() {
        return "Location{world='" + this.world + "', x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", pitch=" + this.pitch + ", yaw=" + this.yaw + "}";
    }

    public Boolean collidesWith(LocationData otherLocation) {
        return this.x == otherLocation.getX() && this.y == otherLocation.getY() && this.z == otherLocation.getZ() && this.getWorld().equals(otherLocation.getWorld());
    }

    public Location toBukkitLocation() {
        return new Location(Bukkit.getWorld((String)this.world), this.x, this.y, this.z, this.yaw, this.pitch);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LocationData)) {
            return false;
        }
        LocationData locationData = (LocationData)obj;
        return this.world.equals(locationData.world) && this.x == locationData.x && this.y == locationData.y && this.z == locationData.z && this.pitch == locationData.pitch && this.yaw == locationData.yaw;
    }
}

