/*
 * Decompiled with CFR 0.152.
 */
package playerquests.builder.quest.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.citizensnpcs.api.npc.NPC;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import playerquests.builder.quest.action.NoneAction;
import playerquests.builder.quest.action.QuestAction;
import playerquests.builder.quest.action.listener.ActionListener;
import playerquests.builder.quest.data.StagePath;
import playerquests.builder.quest.npc.QuestNPC;
import playerquests.builder.quest.stage.QuestStage;
import playerquests.client.quest.QuestClient;
import playerquests.product.FX;
import playerquests.product.Quest;
import playerquests.utility.ChatUtils;

public class QuesterData {
    private final QuestClient quester;
    private final Location location;
    private HashMap<QuestAction<?, ?>, ActionListener<?>> listeners = new HashMap();
    private HashMap<QuestAction<?, ?>, List<FX>> effects = new HashMap();
    private boolean clashLock = false;
    private Map<QuestAction<?, ?>, Boolean> actionConsent = new HashMap();
    private Map<Map.Entry<QuestAction<?, ?>, QuestNPC>, Block> blockNPCs = new HashMap();
    private Map<Map.Entry<QuestAction<?, ?>, QuestNPC>, NPC> entityNPCs = new HashMap();
    private Map<QuestAction<?, ?>, Integer> sleepCount = new HashMap();

    public QuesterData(QuestClient quester, Location location) {
        this.quester = quester;
        this.location = location;
    }

    public QuestClient getQuester() {
        return this.quester;
    }

    public Location getLocation() {
        return this.location;
    }

    public void addListener(QuestAction<?, ?> action, ActionListener<?> actionListener) {
        this.listeners.put(action, actionListener);
    }

    public ActionListener<?> getListener(QuestAction<?, ?> action) {
        return this.listeners.get(action);
    }

    public List<FX> addFX(QuestAction<?, ?> action, List<FX> effectList) {
        this.effects.put(action, effectList);
        return effectList;
    }

    public List<FX> getFX(QuestAction<?, ?> action) {
        return this.effects.getOrDefault(action, List.of());
    }

    public boolean resolveClashes(QuestAction<?, ?> action) {
        if (this.clashLock) {
            return false;
        }
        ArrayList<QuestAction> clashingActions = new ArrayList<QuestAction>(this.getQuester().getTrackedActions().stream().filter(trackedAction -> !trackedAction.equals(action)).filter(trackedAction -> !(trackedAction instanceof NoneAction)).filter(trackedAction -> trackedAction.getLocation() != null && trackedAction.getLocation().equals(action.getLocation())).toList());
        if (clashingActions.isEmpty()) {
            return true;
        }
        this.clashLock = true;
        clashingActions.add(action);
        Player player = this.getQuester().getPlayer();
        TextComponent.Builder message = (TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().appendNewline()).append((Component)Component.text((String)"This area offers more than one action\n"))).appendNewline()).append(Component.text((String)"Click one of the following:").color((TextColor)NamedTextColor.GRAY))).appendNewline()).appendNewline();
        clashingActions.forEach(clashingAction -> {
            QuestStage questStage = clashingAction.getStage();
            Quest quest = questStage.getQuest();
            String path = new StagePath(questStage, List.of(clashingAction)).toString();
            String command = String.format("/action start %s.%s", quest.getID(), path);
            ((TextComponent.Builder)((TextComponent.Builder)message.append((Component)Component.text((String)String.format("> %s.%s%n", quest.getTitle(), path)))).color((TextColor)NamedTextColor.WHITE)).clickEvent(ClickEvent.runCommand((String)command));
        });
        ChatUtils.message(message.asComponent()).player(player).send();
        this.clashLock = false;
        return false;
    }

    public void stopListener(QuestAction<?, ?> action) {
        ActionListener<?> listener = this.getListener(action);
        if (listener == null) {
            return;
        }
        listener.close();
        this.listeners.remove(action);
    }

    public void setConsent(QuestAction<?, ?> action, boolean consent) {
        this.actionConsent.put(action, consent);
    }

    public boolean getConsent(QuestAction<?, ?> action) {
        return this.actionConsent.getOrDefault(action, false);
    }

    public Block getBlockNPC(QuestAction<?, ?> action, QuestNPC npc) {
        return this.blockNPCs.get(Map.entry(action, npc));
    }

    public void addBlockNPC(QuestAction<?, ?> action, QuestNPC npc, Block value) {
        this.blockNPCs.put(Map.entry(action, npc), value);
    }

    public void removeBlockNPC(QuestAction<?, ?> action, QuestNPC npc) {
        this.blockNPCs.remove(Map.entry(action, npc));
    }

    public NPC getCitizenNPC(QuestAction<?, ?> action, QuestNPC npc) {
        return this.entityNPCs.get(Map.entry(action, npc));
    }

    public void addCitizenNPC(QuestAction<?, ?> action, QuestNPC npc, NPC value) {
        this.entityNPCs.put(Map.entry(action, npc), value);
    }

    public void removeEntityNPC(QuestAction<?, ?> action, QuestNPC npc) {
        this.entityNPCs.remove(Map.entry(action, npc));
    }

    public List<Map.Entry<QuestAction<?, ?>, QuestNPC>> getNPCs() {
        ArrayList npcs = new ArrayList();
        npcs.addAll(this.blockNPCs.keySet());
        npcs.addAll(this.entityNPCs.keySet());
        return npcs;
    }

    public int getSleepCount(QuestAction<?, ?> action) {
        return this.sleepCount.getOrDefault(action, 0);
    }

    public void setSleepCount(QuestAction<?, ?> action, int sleepCount) {
        this.sleepCount.put(action, sleepCount);
    }

    public void removeSleepCount(QuestAction<?, ?> action) {
        this.sleepCount.remove(action);
    }
}

