/*
 * Decompiled with CFR 0.152.
 */
package playerquests.builder.quest.data;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import playerquests.builder.quest.action.QuestAction;
import playerquests.builder.quest.stage.QuestStage;
import playerquests.product.Quest;
import playerquests.utility.exception.MissingActionException;
import playerquests.utility.exception.MissingStageException;

public class StagePath {
    private String stage;
    private List<String> actions = new ArrayList<String>();

    public StagePath(String path) {
        String[] segments = path.split("\\.");
        this.stage = segments[0];
        if (segments.length > 1) {
            this.actions = List.of(segments[1].split(","));
        }
    }

    public StagePath(QuestStage stage, @Nullable List<QuestAction<?, ?>> action) {
        this.stage = stage.getID();
        if (action != null) {
            this.actions = action.stream().map(QuestAction::getID).toList();
        }
    }

    public String getStage() {
        if (this.stage == null) {
            throw new MissingStageException("Stage ID is null.", new IllegalStateException("Stage ID must always exist in StagePath."));
        }
        return this.stage;
    }

    public boolean hasActions() {
        return !this.actions.isEmpty();
    }

    public List<String> getActions() {
        if (!this.hasActions()) {
            throw new MissingActionException("No actions are in this StagePath.", new IllegalStateException("Action IDs must be set before retrieval."));
        }
        return this.actions;
    }

    public QuestStage getStage(Quest quest) {
        if (this.stage == null) {
            Map<String, QuestStage> stages = quest.getStages();
            if (stages.isEmpty()) {
                throw new MissingStageException(String.format("No stage found for a StagePath in quest: %s", quest.getID()), new NoSuchElementException("StagePath contains no stages."));
            }
            return stages.values().iterator().next();
        }
        QuestStage stageObject = quest.getStages().get(this.stage);
        if (this.stage == null) {
            throw new MissingStageException(String.format("No stage found for ID: %s in quest: %s.", this.stage, quest.getID()), new NoSuchElementException("Stage not present in the quest stages."));
        }
        return stageObject;
    }

    public List<QuestAction<?, ?>> getActions(Quest quest) {
        ArrayList actionsList = new ArrayList();
        this.actions.forEach(actionID -> {
            QuestAction<?, ?> actionObject = this.getStage(quest).getActions().get(actionID);
            if (actionObject == null) {
                return;
            }
            actionsList.add(actionObject);
        });
        return actionsList;
    }

    @JsonValue
    public String toString() {
        return String.format("%s%s", this.getStage(), this.hasActions() ? "." + String.join((CharSequence)",", this.actions) : "");
    }
}

