/*
 * Decompiled with CFR 0.152.
 */
package playerquests.builder.quest.npc;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import playerquests.Core;
import playerquests.builder.gui.GUIBuilder;
import playerquests.builder.gui.component.GUISlot;
import playerquests.builder.gui.dynamic.Dynamicnpctypes;
import playerquests.builder.gui.dynamic.GUIDynamic;
import playerquests.builder.gui.function.SelectBlock;
import playerquests.builder.gui.function.SelectLocation;
import playerquests.builder.gui.function.data.SelectMethod;
import playerquests.builder.quest.action.QuestAction;
import playerquests.builder.quest.action.WalkAction;
import playerquests.builder.quest.data.LocationData;
import playerquests.builder.quest.data.QuesterData;
import playerquests.builder.quest.npc.NPCType;
import playerquests.builder.quest.npc.QuestNPC;
import playerquests.client.ClientDirector;
import playerquests.client.quest.QuestClient;
import playerquests.utility.ChatUtils;
import playerquests.utility.serialisable.ItemSerialisable;

public class BlockNPC
extends NPCType {
    public BlockNPC() {
    }

    public BlockNPC(String value, QuestNPC npc) {
        super(value, npc);
        this.type = "Block";
    }

    public BlockNPC(ItemSerialisable block, QuestNPC npc) {
        this(block.getAsString(), npc);
    }

    @JsonIgnore
    public ItemSerialisable getBlock() {
        ItemSerialisable finalItemSerialisable = ItemSerialisable.fromItemStack(new ItemStack(Material.RED_WOOL));
        try {
            finalItemSerialisable = new ItemSerialisable(this.value);
            finalItemSerialisable.getBlockData().clone();
        }
        catch (IllegalArgumentException e) {
            ChatUtils.message("malformed block data in a quest.").target(ChatUtils.MessageTarget.CONSOLE).type(ChatUtils.MessageType.ERROR).send();
            Material fallbackMaterial = Material.getMaterial((String)this.value);
            if (fallbackMaterial != null) {
                finalItemSerialisable = ItemSerialisable.fromItemStack(new ItemStack(fallbackMaterial));
            }
            this.value = finalItemSerialisable.getAsString();
        }
        return finalItemSerialisable;
    }

    @JsonProperty(value="value")
    public String getBlockString() {
        return this.value;
    }

    @Override
    public GUISlot createTypeSlot(GUIDynamic screen, ClientDirector director, GUIBuilder gui, Integer slot, QuestNPC npc) {
        return new GUISlot(gui, slot).setLabel("A Block" + (npc.getAssigned() instanceof BlockNPC ? " (Selected)" : "")).setItem(Material.GRASS_BLOCK).onClick(() -> new SelectBlock(Arrays.asList("Select a placed block with right click", Arrays.asList("BARRIER", "DRAGON_EGG"), Arrays.asList(SelectMethod.HIT, SelectMethod.CHAT, SelectMethod.SELECT)), director).onFinish(f -> {
            SelectBlock function = (SelectBlock)f;
            BlockState blockState = function.getResult();
            if (blockState != null) {
                ItemSerialisable itemSerialisable = ItemSerialisable.fromBlockState(blockState);
                BlockNPC blockNPC = new BlockNPC(itemSerialisable, npc);
                npc.assign(blockNPC);
            }
            gui.getResult().display();
            screen.refresh();
        }).execute());
    }

    @Override
    public GUISlot createPlaceSlot(Dynamicnpctypes screen, ClientDirector director, GUIBuilder gui, Integer slot, QuestNPC npc) {
        LocationData locationData = npc.getLocation();
        return new GUISlot(gui, slot).setLabel(String.format("%s", npc.getLocation() == null ? "Place NPC (" + npc.getAssigned().getType() + ")" : "Relocate NPC (" + npc.getAssigned().getType() + ")")).setDescription(locationData != null ? List.of(String.format("X: %.0f", locationData.getX()), String.format("Y: %.0f", locationData.getY()), String.format("Z: %.0f", locationData.getZ())) : List.of()).setItem(npc.isAssigned() ? this.getBlock() : new ItemSerialisable("BARRIER")).onClick(() -> {
            Player player = director.getPlayer();
            PlayerInventory playerInventory = player.getInventory();
            ItemStack[] playerInventoryContents = playerInventory.getContents();
            playerInventory.clear();
            playerInventory.setItemInMainHand(this.getBlock().toItemStack());
            new SelectLocation(Arrays.asList("Place the NPC Block"), director).onFinish(f -> {
                SelectLocation function = (SelectLocation)f;
                LocationData location = function.getResult();
                BlockState blockState = function.getBlockState();
                if (location == null) {
                    return;
                }
                npc.assign(new BlockNPC(ItemSerialisable.fromBlockState(blockState), npc));
                npc.setLocation(location);
                playerInventory.setContents(playerInventoryContents);
                screen.refresh();
            }).execute();
        });
    }

    @Override
    public void refund(QuestClient quester) {
        Player player = quester.getPlayer();
        ItemStack item = this.getBlock().toItemStack();
        PlayerInventory playerInventory = player.getInventory();
        if (playerInventory.firstEmpty() != -1) {
            playerInventory.addItem(new ItemStack[]{item});
            return;
        }
        Location playerLocation = player.getLocation();
        playerLocation.getWorld().dropItem(playerLocation, item);
    }

    @Override
    public void penalise(QuestClient quester) {
        Player player = quester.getPlayer();
        ItemStack item = this.getBlock().toItemStack();
        PlayerInventory playerInventory = player.getInventory();
        item.setAmount(1);
        playerInventory.removeItem(new ItemStack[]{item});
    }

    @Override
    public void unregister(QuestAction<?, ?> action, QuestClient quester) {
        quester.getData().removeBlockNPC(action, this.getNPC());
    }

    @Override
    public void despawn(QuestAction<?, ?> action, QuestClient quester) {
        Player player = quester.getPlayer();
        Block block = quester.getData().getBlockNPC(action, this.getNPC());
        if (block == null) {
            return;
        }
        player.sendBlockChange(block.getLocation(), Material.AIR.createBlockData());
    }

    @Override
    public void register(QuestAction<?, ?> action, QuestClient quester, Object value) {
        quester.getData().addBlockNPC(action, this.getNPC(), (Block)value);
    }

    @Override
    public Object spawn(QuestAction<?, ?> action, QuestClient quester) {
        Player player = quester.getPlayer();
        Location location = this.getNPC().getLocation().toBukkitLocation();
        ItemSerialisable itemSerialisable = this.getBlock();
        BlockData blockData = itemSerialisable.getBlockData();
        player.sendBlockChange(location, blockData);
        itemSerialisable.sendBlockUpdate(blockData, player, location);
        return this.getNPC().getLocation().toBukkitLocation().getBlock();
    }

    @Override
    public boolean isCurrentlyAt(LocationData locationData, QuesterData questerData, QuestAction<?, ?> action) {
        Block block = questerData.getBlockNPC(action, this.npc);
        if (block == null) {
            return false;
        }
        Location blockLocation = block.getLocation();
        blockLocation.setWorld(Bukkit.getWorld((String)this.getNPC().getLocation().getWorld()));
        return locationData.toBukkitLocation().distanceSquared(blockLocation) <= 1.0;
    }

    @Override
    public void walkTo(LocationData locationData, final QuesterData questerData, final WalkAction action) {
        final QuestNPC walkingNpc = this.npc;
        walkingNpc.spawn(action, questerData.getQuester());
        final Player player = questerData.getQuester().getPlayer();
        final Location startLoc = this.getNPC().getLocation().toBukkitLocation();
        final Location endLoc = locationData.toBukkitLocation();
        Material movingBlockType = this.getBlock().toItemStack().getType();
        final BlockData blockData = movingBlockType.createBlockData();
        long delayBetweenSteps = 7L;
        Vector direction = endLoc.toVector().subtract(startLoc.toVector());
        double distance = direction.length();
        final int totalSteps = (int)distance;
        final Vector stepVector = direction.normalize().multiply(distance / (double)totalSteps);
        new BukkitRunnable(this){
            private int currentStep = 0;

            public void run() {
                if (!questerData.getQuester().getTrackedActions().contains(action)) {
                    this.cancel();
                }
                if (this.currentStep > 0) {
                    Location prevLoc = startLoc.clone().add(stepVector.clone().multiply(this.currentStep - 1));
                    player.sendBlockChange(prevLoc, Material.AIR.createBlockData());
                }
                if (this.currentStep >= totalSteps) {
                    player.sendBlockChange(endLoc, blockData);
                    new BukkitRunnable(){

                        public void run() {
                            questerData.addBlockNPC(action, walkingNpc, endLoc.getBlock());
                            action.check(questerData);
                        }
                    }.runTaskLater(Core.getPlugin(), 20L);
                    this.cancel();
                    return;
                }
                Location currentLocation = startLoc.clone().add(stepVector.clone().multiply(this.currentStep));
                player.sendBlockChange(currentLocation, blockData);
                ++this.currentStep;
            }
        }.runTaskTimer(Core.getPlugin(), 0L, delayBetweenSteps);
    }
}

