/*
 * Decompiled with CFR 0.152.
 */
package playerquests.builder.quest.npc;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Arrays;
import java.util.List;
import playerquests.builder.gui.GUIBuilder;
import playerquests.builder.gui.component.GUISlot;
import playerquests.builder.gui.dynamic.Dynamicnpctypes;
import playerquests.builder.gui.dynamic.GUIDynamic;
import playerquests.builder.quest.action.QuestAction;
import playerquests.builder.quest.action.WalkAction;
import playerquests.builder.quest.data.LocationData;
import playerquests.builder.quest.data.QuesterData;
import playerquests.builder.quest.npc.BlockNPC;
import playerquests.builder.quest.npc.EntityNPC;
import playerquests.builder.quest.npc.QuestNPC;
import playerquests.client.ClientDirector;
import playerquests.client.quest.QuestClient;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=BlockNPC.class, name="BlockNPC"), @JsonSubTypes.Type(value=EntityNPC.class, name="EntityNPC")})
public abstract class NPCType {
    @JsonBackReference
    protected QuestNPC npc;
    protected String type;
    protected String value;

    protected NPCType() {
    }

    protected NPCType(String value, QuestNPC npc) {
        this.value = value;
        this.npc = npc;
    }

    public static List<Class<? extends NPCType>> getAllTypes() {
        JsonSubTypes jsonSubTypes = NPCType.class.getDeclaredAnnotation(JsonSubTypes.class);
        return Arrays.stream(jsonSubTypes.value()).map(JsonSubTypes.Type::value).filter(NPCType.class::isAssignableFrom).map(clazz -> clazz).toList();
    }

    @JsonIgnore
    public String getType() {
        return this.getClass().getSimpleName();
    }

    public QuestNPC getNPC() {
        return this.npc;
    }

    public String getValue() {
        return this.value;
    }

    @JsonIgnore
    public abstract void refund(QuestClient var1);

    @JsonIgnore
    public abstract void penalise(QuestClient var1);

    public abstract GUISlot createTypeSlot(GUIDynamic var1, ClientDirector var2, GUIBuilder var3, Integer var4, QuestNPC var5);

    public abstract GUISlot createPlaceSlot(Dynamicnpctypes var1, ClientDirector var2, GUIBuilder var3, Integer var4, QuestNPC var5);

    protected abstract void unregister(QuestAction<?, ?> var1, QuestClient var2);

    protected abstract void despawn(QuestAction<?, ?> var1, QuestClient var2);

    protected abstract void register(QuestAction<?, ?> var1, QuestClient var2, Object var3);

    protected abstract Object spawn(QuestAction<?, ?> var1, QuestClient var2);

    public abstract boolean isCurrentlyAt(LocationData var1, QuesterData var2, QuestAction<?, ?> var3);

    public abstract void walkTo(LocationData var1, QuesterData var2, WalkAction var3);
}

