/*
 * Decompiled with CFR 0.152.
 */
package playerquests.builder.quest.npc;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import playerquests.builder.quest.QuestBuilder;
import playerquests.builder.quest.action.QuestAction;
import playerquests.builder.quest.data.LocationData;
import playerquests.builder.quest.npc.BlockNPC;
import playerquests.builder.quest.npc.NPCType;
import playerquests.client.ClientDirector;
import playerquests.client.quest.QuestClient;
import playerquests.product.Quest;
import playerquests.utility.ChatUtils;
import playerquests.utility.serialisable.ItemSerialisable;

public class QuestNPC {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="name")
    private String name = null;
    @JsonBackReference
    private Quest quest;
    @JsonIgnore
    private ClientDirector director;
    @JsonProperty(value="assigned")
    @JsonManagedReference
    private NPCType assigned;
    @JsonProperty(value="location")
    private LocationData location;

    public QuestNPC() {
    }

    public QuestNPC(@JsonProperty(value="id") String id) {
        this.id = id;
    }

    public String getID() {
        return this.id;
    }

    @JsonIgnore
    public String getTitle() {
        return this.getName();
    }

    public String toString() {
        return this.getID();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonIgnore
    public Boolean save(QuestBuilder quest, QuestNPC npc) {
        this.quest = quest.build();
        this.director = quest.getDirector();
        return quest.addNPC(npc);
    }

    @JsonIgnore
    public void setID(String id) {
        this.id = id;
    }

    @JsonIgnore
    public boolean isValid() {
        UUID questCreator = this.quest.getCreator();
        Player player = null;
        ChatUtils.MessageBuilder response = ChatUtils.message("Something is wrong with a quest NPC").type(ChatUtils.MessageType.ERROR).target(ChatUtils.MessageTarget.CONSOLE).style(ChatUtils.MessageStyle.PLAIN);
        boolean isValid = true;
        if (this.name == null) {
            response.content("The NPC name must be set");
            isValid = false;
        }
        if (this.assigned == null) {
            response.content("The NPC must be assigned to a type");
            isValid = false;
        }
        if (this.location == null) {
            response.content("The NPC must be placed at a location");
            isValid = false;
        }
        if (questCreator != null) {
            player = Bukkit.getPlayer((UUID)this.quest.getCreator());
            response.player(player).style(ChatUtils.MessageStyle.PRETTY);
        }
        if (!isValid) {
            response.send();
        }
        return isValid;
    }

    @JsonIgnore
    public void assign(NPCType npcType) {
        this.assigned = npcType;
    }

    @JsonIgnore
    public void setLocation(LocationData location) {
        this.location = location;
    }

    @JsonIgnore
    public LocationData getLocation() {
        return this.location;
    }

    @JsonIgnore
    public ItemSerialisable getBlock() {
        NPCType nPCType = this.assigned;
        if (nPCType instanceof BlockNPC) {
            BlockNPC npc = (BlockNPC)nPCType;
            return npc.getBlock();
        }
        return ItemSerialisable.fromItemStack(new ItemStack(Material.RED_STAINED_GLASS));
    }

    @JsonIgnore
    public boolean isAssigned() {
        return this.assigned != null;
    }

    @JsonIgnore
    public NPCType getAssigned() {
        return this.assigned;
    }

    @JsonIgnore
    public void spawn(QuestAction<?, ?> action, QuestClient quester) {
        this.assigned.register(action, quester, this.assigned.spawn(action, quester));
    }

    @JsonIgnore
    public void despawn(QuestAction<?, ?> action, QuestClient quester) {
        this.assigned.despawn(action, quester);
        this.assigned.unregister(action, quester);
    }

    @JsonIgnore
    public void despawn(QuestClient quester) {
        quester.getTrackedActions().forEach(action -> this.despawn((QuestAction<?, ?>)action, quester));
    }

    public Quest getQuest() {
        return this.quest;
    }

    public void setQuest(Quest quest) {
        this.quest = quest;
    }

    @JsonIgnore
    public void refund(QuestClient quester) {
        this.getAssigned().refund(quester);
    }

    @JsonIgnore
    public void penalise(QuestClient quester) {
        this.getAssigned().penalise(quester);
    }
}

