/*
 * Decompiled with CFR 0.152.
 */
package playerquests.builder.quest.stage;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import playerquests.builder.quest.action.QuestAction;
import playerquests.builder.quest.data.StagePath;
import playerquests.product.Quest;

public class QuestStage {
    @JsonBackReference
    private Quest quest;
    @JsonProperty(value="id")
    private String id;
    @JsonManagedReference
    private Map<String, QuestAction<?, ?>> actions = new HashMap();
    @JsonProperty(value="startpoints")
    private List<StagePath> startPoints = new ArrayList<StagePath>();
    @JsonProperty(value="label")
    private String label;

    public QuestStage(@JsonProperty(value="id") String id) {
        this.id = id;
    }

    public QuestStage(Quest quest, Integer idNumber) {
        this.id = "stage_" + idNumber;
        this.quest = quest;
    }

    public QuestStage(Quest quest, String id) {
        this(quest, Integer.parseInt(id.substring(6)));
    }

    public void setQuest(Quest quest) {
        this.quest = quest;
    }

    public Quest getQuest() {
        return this.quest;
    }

    @JsonIgnore
    public String getID() {
        return this.id;
    }

    public String toString() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public Map<String, QuestAction<?, ?>> getActions() {
        return this.actions;
    }

    @JsonIgnore
    public List<QuestAction<?, ?>> getOrderedActions() {
        return this.actions.values().stream().sorted(Comparator.comparingInt(action -> {
            String[] parts = action.getID().split("_");
            return Integer.parseInt(parts[parts.length - 1]);
        })).collect(Collectors.toCollection(LinkedList::new));
    }

    @JsonIgnore
    public String addAction(QuestAction<?, ?> action) {
        String actionID = "action_" + this.actions.size();
        action.setID(actionID);
        this.actions.put(action.getID(), action);
        return actionID;
    }

    public List<StagePath> getStartPoints() {
        if (this.startPoints == null) {
            return List.of();
        }
        return this.startPoints;
    }

    public void setStartPoints(List<StagePath> startPoints) {
        if (startPoints == null) {
            this.startPoints = List.of();
            return;
        }
        this.startPoints = startPoints;
    }

    public QuestAction<?, ?> replaceAction(QuestAction<?, ?> oldAction, QuestAction<?, ?> newAction) {
        String oldId = oldAction.getID();
        newAction.setStage(this);
        newAction.setID(oldId);
        this.actions.replace(oldId, newAction);
        return newAction;
    }

    public Optional<String> removeAction(QuestAction<?, ?> action) {
        List allActions = this.quest.getStages().values().stream().map(QuestStage::getActions).map(Map::values).flatMap(Collection::stream).toList();
        List<String> dependencies = allActions.stream().filter(actionsList -> actionsList.getData().getNextActions().stream().flatMap(path -> path.getActions(this.quest).stream()).anyMatch(actionMatch -> actionMatch.equals(action))).map(actionsList -> actionsList.getID()).toList();
        if (!dependencies.isEmpty()) {
            return Optional.of("This action is pointed to by another. Please remove it as a 'next' action. (on " + String.join((CharSequence)", ", dependencies) + ")");
        }
        this.actions.remove(action.getID());
        return Optional.empty();
    }

    @JsonIgnore
    public String getLabel() {
        if (this.label == null) {
            return this.getID();
        }
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean hasLabel() {
        return this.label != null;
    }
}

