/*
 * Decompiled with CFR 0.152.
 */
package playerquests.client;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Player;
import playerquests.builder.gui.GUIBuilder;
import playerquests.client.Director;
import playerquests.utility.singleton.PlayerQuests;

public class ClientDirector
extends Director {
    HashMap<Class<?>, Object> currentInstances = new HashMap();
    Player player;

    public ClientDirector(Player player) {
        this.player = player;
        this.validateCurrentInstances();
        PlayerQuests.getInstance().addDirector(this);
    }

    private void validateCurrentInstances() {
        this.currentInstances.putIfAbsent(GUIBuilder.class, new GUIBuilder(this));
    }

    public Object getCurrentInstance(Class<?> classType) {
        return this.currentInstances.get(classType);
    }

    public void setCurrentInstance(Object instance) {
        this.setCurrentInstance(instance, instance.getClass());
    }

    public void setCurrentInstance(Object instance, Class<?> classType) {
        if (this.currentInstances.containsKey(instance)) {
            this.currentInstances.remove(classType);
        }
        this.currentInstances.put(classType, instance);
    }

    public void removeCurrentInstance(Class<?> classType) {
        this.currentInstances.remove(classType);
    }

    public Map<Class<?>, Object> getCurrentInstances() {
        return this.currentInstances;
    }

    public GUIBuilder newGUI() {
        GUIBuilder guiBuilder = (GUIBuilder)this.currentInstances.get(GUIBuilder.class);
        guiBuilder.reset();
        return guiBuilder;
    }

    public GUIBuilder getGUI() {
        return (GUIBuilder)this.currentInstances.get(GUIBuilder.class);
    }

    public Player getPlayer() {
        return this.player;
    }

    public void clearCurrentInstances() {
        this.currentInstances.clear();
        this.validateCurrentInstances();
    }

    @Override
    public void close() {
        this.getGUI().getResult().close();
    }
}

