/*
 * Decompiled with CFR 0.152.
 */
package playerquests.client.chat.command;

import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import playerquests.Core;
import playerquests.builder.quest.action.QuestAction;
import playerquests.builder.quest.data.StagePath;
import playerquests.client.chat.command.ChatCommand;
import playerquests.client.quest.QuestClient;
import playerquests.product.Quest;
import playerquests.utility.singleton.QuestRegistry;

public class Commandaction
extends ChatCommand {
    public Commandaction() {
        super("action");
    }

    @Override
    public boolean execute(CommandSender sender, Command command, String label, String[] args) {
        boolean isPlayer = sender instanceof Player;
        if (!isPlayer) {
            return false;
        }
        if (args.length <= 1) {
            return false;
        }
        String keyword = args[0].toLowerCase();
        Player player = Bukkit.getPlayer((String)sender.getName());
        QuestClient quester = Core.getQuestRegistry().getQuester(player);
        switch (keyword) {
            case "start": {
                return this.startAction(args, quester);
            }
            case "consent": {
                return this.setConsent(args, quester);
            }
        }
        return false;
    }

    private boolean startAction(String[] args, QuestClient quester) {
        Target target = this.actionTargetDecode(args);
        Quest quest = QuestRegistry.getInstance().getQuest(target.questID());
        StagePath path = new StagePath(target.pathCode());
        path.getActions(quest).forEach(action -> quester.start((QuestAction<?, ?>)action, false));
        return true;
    }

    private boolean setConsent(String[] args, QuestClient quester) {
        Target target = this.actionTargetDecode(args);
        Quest quest = QuestRegistry.getInstance().getQuest(target.questID());
        StagePath path = new StagePath(target.pathCode());
        path.getActions(quest).forEach(action -> quester.getData().setConsent((QuestAction<?, ?>)action, true));
        return true;
    }

    private Target actionTargetDecode(String[] args) {
        String partialQuestID = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length - 1));
        String partialStagePath = args[args.length - 1];
        String[] resolvePartial = partialStagePath.split("\\.");
        return new Target(String.format("%s %s", partialQuestID, resolvePartial[0]).trim(), String.format("%s.%s", resolvePartial[1], resolvePartial[2]).trim());
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        boolean isPlayer = sender instanceof Player;
        Player player = Bukkit.getPlayer((String)sender.getName());
        switch (args.length) {
            case 1: {
                return List.of("start", "consent");
            }
            case 2: {
                if (!isPlayer) {
                    return List.of();
                }
                return Core.getQuestRegistry().getQuester(player).getDiary().getQuestProgress().entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(path -> String.format("%s.%s", ((Quest)entry.getKey()).getID(), path.toString()))).toList();
            }
        }
        return List.of();
    }

    public record Target(String questID, String pathCode) {
    }
}

