/*
 * Decompiled with CFR 0.152.
 */
package playerquests.client.chat.command;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import playerquests.client.ClientDirector;
import playerquests.client.chat.command.ChatCommand;
import playerquests.utility.ChatUtils;
import playerquests.utility.FileUtils;
import playerquests.utility.singleton.PlayerQuests;
import playerquests.utility.test.TestUtility;
import playerquests.utility.test.Testdatabase;
import playerquests.utility.test.Testquest;

public class Commandtest
extends ChatCommand {
    Map<String, Class<? extends TestUtility>> tests = Map.of("database", Testdatabase.class, "quest", Testquest.class);
    private String testLogFilename;

    public Commandtest() {
        super("test");
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        switch (args.length) {
            case 1: {
                ArrayList<String> options = new ArrayList<String>(this.tests.keySet());
                options.add("reload");
                return options;
            }
        }
        return List.of();
    }

    @Override
    public boolean execute(CommandSender sender, Command command, String label, String[] args) {
        boolean isPlayer = sender instanceof Player;
        if (!isPlayer) {
            ChatUtils.message("Cannot run tests as a non-player").type(ChatUtils.MessageType.ERROR).style(ChatUtils.MessageStyle.PLAIN).target(ChatUtils.MessageTarget.CONSOLE).send();
            return false;
        }
        Player player = (Player)sender;
        ClientDirector clientDirector = new ClientDirector(player);
        if (args.length == 0) {
            this.runAllTests(clientDirector);
            return true;
        }
        if (args.length == 1 && args[0].equalsIgnoreCase("reload")) {
            PlayerQuests.reload();
            return true;
        }
        String testKeyword = args[0].toLowerCase();
        this.runSpecificTest(clientDirector, testKeyword);
        return true;
    }

    private void runSpecificTest(ClientDirector clientDirector, String testKeyword) {
        Player player = clientDirector.getPlayer();
        Class<? extends TestUtility> testClass = this.tests.get(testKeyword);
        if (testClass == null) {
            ChatUtils.message(String.format("Could not find '%s' test module", testKeyword)).style(ChatUtils.MessageStyle.PRETTY).type(ChatUtils.MessageType.ERROR).player(player).send();
            return;
        }
        try {
            TestUtility testUtility = testClass.getDeclaredConstructor(ClientDirector.class).newInstance(clientDirector);
            testUtility.runTests(testResult -> this.sendTestSingular(clientDirector, (TestUtility.TestResult)testResult), testResults -> this.sendTestSummary(clientDirector, (List<TestUtility.TestResult>)testResults));
        }
        catch (Exception e) {
            String baseMessage = String.format("Could not run the '%s' test module", testKeyword);
            ChatUtils.message(baseMessage + "\nCheck the console for more details").style(ChatUtils.MessageStyle.PRETTY).type(ChatUtils.MessageType.ERROR).player(player).send();
            ChatUtils.message(baseMessage + ", Cause: " + e.getMessage()).style(ChatUtils.MessageStyle.PRETTY).type(ChatUtils.MessageType.ERROR).target(ChatUtils.MessageTarget.CONSOLE).send();
        }
    }

    private void runAllTests(ClientDirector clientDirector) {
        this.testLogFilename = "test.log";
        try {
            FileUtils.delete(this.testLogFilename);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.tests.keySet().forEach(testKeyword -> this.runSpecificTest(clientDirector, (String)testKeyword));
    }

    private void sendTestSingular(ClientDirector clientDirector, TestUtility.TestResult testResult) {
        Player player = clientDirector.getPlayer();
        String prefix = testResult.didTestPass ? "[PASS]" : "[FAIL]";
        NamedTextColor color = testResult.didTestPass ? NamedTextColor.GREEN : NamedTextColor.RED;
        String icon = testResult.didTestPass ? "\u2705" : "\u274c";
        Component message = ((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.empty().append((Component)Component.text((String)("(" + testResult.className + ") ")))).append((Component)Component.text((String)(testResult.testLabel + ": ")))).append((Component)Component.text((String)(prefix + " ")))).append((Component)Component.text((String)icon))).color((TextColor)color);
        ChatUtils.message(message).style(ChatUtils.MessageStyle.SIMPLE).type(ChatUtils.MessageType.NOTIF).player(player).send();
    }

    private void sendTestSummary(ClientDirector clientDirector, List<TestUtility.TestResult> testResults) {
        Player player = clientDirector.getPlayer();
        List<TestUtility.TestResult> passedTests = testResults.stream().filter(result -> result.didTestPass).toList();
        String message = String.format("%s: %d/%d Tests Passed!", testResults.getFirst().className, passedTests.size(), testResults.size());
        ChatUtils.message(message).style(ChatUtils.MessageStyle.SIMPLE).type(ChatUtils.MessageType.NOTIF).player(player).send();
        try {
            FileUtils.append(this.testLogFilename, String.join((CharSequence)"", testResults.stream().map(res -> res.toString() + "\n").toList()).getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

