/*
 * Decompiled with CFR 0.152.
 */
package playerquests.client.gui.listener;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.persistence.PersistentDataType;
import playerquests.Core;
import playerquests.builder.gui.GUIBuilder;
import playerquests.builder.gui.component.GUISlot;

public class GUIListener
implements Listener {
    private Map<Player, GUIBuilder> builders = new HashMap<Player, GUIBuilder>();

    public GUIListener(GUIBuilder builder) {
        Player player = Bukkit.getPlayer((UUID)builder.getDirector().getPlayer().getUniqueId());
        this.builders.put(player, builder);
    }

    private Boolean isGUI(Player player) {
        GUIBuilder builder = this.builders.get(player);
        return builder != null;
    }

    private Boolean isGUIInventory(InventoryClickEvent event) {
        return Optional.ofNullable(event.getClickedInventory()).map(inventory -> inventory.getType() == InventoryType.CHEST).orElse(false);
    }

    private Boolean isEmptySlot(Integer slotPosition, Player player) {
        GUIBuilder builder = this.builders.get(player);
        return builder.getSlot(slotPosition) == null;
    }

    @EventHandler
    public void onDragItem(InventoryDragEvent event) {
        Player player = Bukkit.getPlayer((UUID)event.getView().getPlayer().getUniqueId());
        if (this.isGUI(player).booleanValue()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onGUIClose(InventoryCloseEvent event) {
        Player player = Bukkit.getPlayer((UUID)event.getPlayer().getUniqueId());
        if (!this.isGUI(player).booleanValue()) {
            return;
        }
        Bukkit.getScheduler().runTask(Core.getPlugin(), () -> {
            if (event.getView() == null) {
                return;
            }
            PlayerInventory playerInventory = player.getInventory();
            playerInventory.forEach(item -> {
                if (item == null) {
                    return;
                }
                String guiKey = (String)item.getItemMeta().getPersistentDataContainer().get(Core.getGUIKey(), PersistentDataType.STRING);
                if (guiKey == null) {
                    return;
                }
                if (guiKey.equals("true")) {
                    playerInventory.remove(item);
                }
            });
        });
    }

    @EventHandler
    public void onDropItem(PlayerDropItemEvent event) {
        Player player = event.getPlayer();
        if (this.isGUI(player).booleanValue() && event.getItemDrop().getItemStack().getItemMeta().getPersistentDataContainer().get(Core.getGUIKey(), PersistentDataType.STRING) == "true") {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onClickItem(InventoryClickEvent event) {
        Player player = Bukkit.getPlayer((UUID)event.getView().getPlayer().getUniqueId());
        if (!this.isGUIInventory(event).booleanValue() || !this.isGUI(player).booleanValue()) {
            return;
        }
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Integer slotPosition = event.getSlot() + 1;
        GUIBuilder builder = this.builders.get(player);
        GUISlot slot = builder.getSlot(slotPosition);
        if (!this.isGUI(player).booleanValue() || slot == null) {
            return;
        }
        switch (builder.getFrame().getMode()) {
            case CLICK: {
                if (this.isEmptySlot(slotPosition, player).booleanValue()) break;
                event.setCancelled(true);
                break;
            }
            case ARRANGE: {
                event.setCancelled(true);
                break;
            }
        }
        slot.execute((Player)event.getWhoClicked());
        slot.clicked();
    }

    @EventHandler
    public void onCloseGUI(InventoryCloseEvent event) {
        Player player = Bukkit.getPlayer((UUID)event.getPlayer().getUniqueId());
        GUIBuilder builder = this.builders.get(player);
        if (this.isGUI(player).booleanValue() && !builder.getResult().isLocked().booleanValue()) {
            builder.dispose();
        }
    }
}

