/*
 * Decompiled with CFR 0.152.
 */
package playerquests.client.quest;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;
import playerquests.builder.quest.action.QuestAction;
import playerquests.builder.quest.data.QuesterData;
import playerquests.builder.quest.data.StagePath;
import playerquests.builder.quest.npc.QuestNPC;
import playerquests.client.quest.QuestDiary;
import playerquests.product.Quest;
import playerquests.utility.ChatUtils;
import playerquests.utility.singleton.Database;
import playerquests.utility.singleton.QuestRegistry;

public class QuestClient {
    private final Player player;
    private QuestDiary diary;
    private QuesterData data;
    private List<QuestAction<?, ?>> trackedActions = new ArrayList();

    public QuestClient(Player player) {
        this.player = player;
        QuestRegistry.getInstance().addQuester(this);
        this.data = new QuesterData(this, this.player.getLocation());
        new QuestDiary(this);
    }

    public Player getPlayer() {
        return this.player;
    }

    public QuestDiary getDiary() {
        return this.diary;
    }

    public void start(QuestDiary diary) {
        if (this.diary != null) {
            throw new IllegalStateException("A diary was started twice!");
        }
        this.diary = diary;
        diary.getQuestProgress().entrySet().stream().forEach(entry -> {
            Quest quest = (Quest)entry.getKey();
            this.start((List)entry.getValue(), quest);
        });
    }

    public void start(List<StagePath> paths, Quest quest) {
        this.start(paths, quest, true);
    }

    public void start(List<StagePath> paths, Quest quest, boolean force) {
        paths.forEach(path -> {
            if (!path.hasActions()) {
                this.start(path.getStage(quest).getStartPoints(), quest);
                return;
            }
            List<QuestAction<?, ?>> actions = path.getActions(quest);
            actions.forEach(action -> this.start((QuestAction<?, ?>)action, force));
        });
    }

    public void start(QuestAction<?, ?> action, boolean force) {
        Quest quest = action.getStage().getQuest();
        Integer completionState = this.getDiary().getActionCompletionState(quest, action);
        if (!force && completionState == 1) {
            ChatUtils.message("Already completed this quest action! ^_^").player(this.getPlayer()).type(ChatUtils.MessageType.NOTIF).send();
            return;
        }
        if (completionState == 2) {
            ChatUtils.message(String.format("'%s' quest action already in progress! ^_^", action.getName())).player(this.getPlayer()).type(ChatUtils.MessageType.NOTIF).send();
            return;
        }
        if (!quest.isAllowed()) {
            quest.toggle(false);
            return;
        }
        action.run(this.getData());
        this.trackAction(action);
        StagePath actionPath = new StagePath(action.getStage(), List.of(action));
        Database.getInstance().setDiaryEntryCompletion(this.diary.getID(), quest.getID(), actionPath, false);
    }

    private void trackAction(QuestAction<?, ?> action) {
        this.trackedActions.add(action);
    }

    public boolean untrackAction(QuestAction<?, ?> action) {
        return this.trackedActions.removeIf(theAction -> theAction.equals(action));
    }

    public void stop(Quest quest, StagePath path) {
        path.getActions(quest).forEach(action -> action.stop(this.getData()));
    }

    public List<QuestAction<?, ?>> getTrackedActions() {
        return this.trackedActions;
    }

    public void stop(Quest quest) {
        ArrayList trackedActionsCloned = new ArrayList(this.trackedActions);
        this.trackedActions = trackedActionsCloned.stream().filter(action -> {
            boolean match = action.getStage().getQuest().getID().equals(quest.getID());
            if (match) {
                action.stop(this.getData(), true);
            }
            return !match;
        }).collect(Collectors.toCollection(ArrayList::new));
    }

    public QuesterData getData() {
        return this.data;
    }

    public void clear() {
        this.getData().getNPCs().forEach(npc -> ((QuestNPC)npc.getValue()).despawn(this));
    }
}

