/*
 * Decompiled with CFR 0.152.
 */
package playerquests.client.quest;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import playerquests.builder.quest.action.NoneAction;
import playerquests.builder.quest.action.QuestAction;
import playerquests.builder.quest.data.StagePath;
import playerquests.client.quest.QuestClient;
import playerquests.product.Quest;
import playerquests.product.fx.ParticleFX;
import playerquests.utility.singleton.Database;
import playerquests.utility.singleton.QuestRegistry;

public class QuestDiary {
    private final QuestClient client;
    private final String id;
    private Map<Quest, List<StagePath>> questProgress = new HashMap<Quest, List<StagePath>>();

    public QuestDiary(QuestClient client) {
        this.client = client;
        this.id = String.format("%s_diary", client.getPlayer().getUniqueId().toString());
        Map<Quest, List<Map<StagePath, Boolean>>> diaryEntries = Database.getInstance().getDiaryEntries(this);
        Map<String, List> currentProgress = diaryEntries.entrySet().stream().filter(entry -> entry.getKey() != null).collect(Collectors.toMap(entry -> ((Quest)entry.getKey()).getID(), entry -> ((List)entry.getValue()).stream().flatMap(map -> map.entrySet().stream()).filter(stageEntry -> (Boolean)stageEntry.getValue() == false).map(Map.Entry::getKey).toList()));
        if (currentProgress.isEmpty()) {
            Database.getInstance().setQuestDiary(this);
        }
        QuestRegistry.getInstance().getAllQuests().values().stream().filter(quest -> quest.isToggled()).forEach(quest -> {
            List progress = quest.getStartPoints();
            if (currentProgress != null && !currentProgress.isEmpty()) {
                progress = (List)currentProgress.get(quest.getID());
            }
            if (progress == null) {
                return;
            }
            this.questProgress.put((Quest)quest, progress);
        });
        this.client.start(this);
    }

    public String getID() {
        return this.id;
    }

    public Map<Quest, List<StagePath>> getQuestProgress() {
        return this.getQuestProgress(null);
    }

    public Map<Quest, List<StagePath>> getQuestProgress(Quest quest) {
        if (quest == null) {
            return this.questProgress;
        }
        return Map.of(quest, this.questProgress.get(quest));
    }

    public void setQuestProgress(Quest quest, List<StagePath> paths) {
        this.questProgress.put(quest, paths);
    }

    public void add(Quest quest) {
        List<StagePath> startPoints = quest.getStartPoints();
        this.client.start(startPoints, quest);
        this.setQuestProgress(quest, startPoints);
    }

    public void remove(Quest quest) {
        Optional<Map.Entry> entry = this.questProgress.entrySet().stream().filter(theQuest -> ((Quest)theQuest.getKey()).getID().equals(quest.getID())).findFirst();
        if (entry.isEmpty()) {
            return;
        }
        this.client.stop(quest);
    }

    public Integer getActionCompletionState(Quest quest, QuestAction<?, ?> action) {
        Map<Quest, List<Map<StagePath, Boolean>>> rawEntries = Database.getInstance().getDiaryEntries(this);
        if (rawEntries == null || !rawEntries.containsKey(quest)) {
            return 0;
        }
        if (action instanceof NoneAction) {
            return 3;
        }
        if (this.getQuestClient().getTrackedActions().contains(action)) {
            return 2;
        }
        List<Map<StagePath, Boolean>> questEntries = rawEntries.get(quest);
        if (questEntries.stream().flatMap(pathMap -> pathMap.entrySet().stream()).filter(pathEntry -> ((StagePath)pathEntry.getKey()).getActions(quest).contains(action)).noneMatch(entry -> (Boolean)entry.getValue() == false)) {
            return 1;
        }
        return 0;
    }

    public QuestClient getQuestClient() {
        return this.client;
    }

    public ParticleFX getActionParticle() {
        return ParticleFX.SPARKLE;
    }
}

