/*
 * Decompiled with CFR 0.152.
 */
package playerquests.product;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import playerquests.Core;
import playerquests.builder.gui.GUIBuilder;
import playerquests.builder.gui.component.GUIFrame;
import playerquests.builder.gui.component.GUISlot;

public class GUI {
    private GUIBuilder builder;
    private Boolean locked = false;
    private InventoryView view = null;
    private Inventory inventory = null;
    private GUIFrame frame;
    private Map<Integer, GUISlot> slots;

    public GUI(GUIBuilder builder) {
        this.builder = builder;
        this.frame = builder.getFrame();
        this.slots = builder.getSlots();
    }

    public void open() {
        this.inventory = Bukkit.createInventory((InventoryHolder)this.builder.getDirector().getPlayer(), (int)this.frame.getSize(), (Component)Component.text((String)this.frame.getTitle()));
        this.display();
        this.draw();
    }

    public boolean isOpen() {
        return this.view != null;
    }

    public void close() {
        Optional.ofNullable(this.view).ifPresent(v -> v.close());
        this.builder.dispose();
    }

    public void draw() {
        if (this.view == null) {
            throw new IllegalAccessError("Could not draw on a GUI which isn't open.");
        }
        this.frame = this.builder.getFrame();
        this.slots = this.builder.getSlots();
        this.drawSlots();
    }

    private void drawSlots() {
        this.slots.forEach((position, slot) -> {
            ItemStack item = slot.getItem().toItemStack();
            ItemMeta itemMeta = item.getItemMeta();
            if (itemMeta == null) {
                return;
            }
            itemMeta.lore(List.of());
            itemMeta.displayName(slot.getLabel());
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_STORED_ENCHANTS, ItemFlag.HIDE_ATTRIBUTES});
            itemMeta.lore(null);
            if (!slot.getDescription().isEmpty()) {
                itemMeta.lore(slot.getDescription());
            }
            if (slot.isGlinting()) {
                itemMeta.setEnchantmentGlintOverride(Boolean.valueOf(true));
            }
            item.setAmount(slot.getCount().intValue());
            itemMeta.getPersistentDataContainer().set(Core.getGUIKey(), PersistentDataType.STRING, (Object)"true");
            item.setItemMeta(itemMeta);
            if (position > 0 && position <= this.frame.getSize()) {
                this.inventory.setItem(position - 1, item);
            }
        });
    }

    public void clearSlots() {
        this.inventory.clear();
    }

    public void display() {
        this.view = this.builder.getDirector().getPlayer().openInventory(this.inventory);
        this.locked = false;
    }

    public void minimise() {
        this.locked = true;
        Optional.ofNullable(this.view).ifPresent(v -> v.close());
    }

    public Boolean isLocked() {
        return this.locked;
    }
}

