/*
 * Decompiled with CFR 0.152.
 */
package playerquests.utility;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import playerquests.Core;

public class ChatUtils {
    private ChatUtils() {
        throw new AssertionError((Object)"ChatUtils should not be instantiated.");
    }

    private static String[] newlineArray() {
        return ChatUtils.newlineArray(0, 100);
    }

    private static String[] newlineArray(Integer start, Integer end) {
        return Collections.nCopies(end - start, "\n").toArray(new String[0]);
    }

    public static void clearChat() {
        ChatUtils.clearChat(100);
    }

    public static void clearChat(Integer lines) {
        Core.getPlugin().getServer().getOnlinePlayers().stream().forEach(player -> ChatUtils.clearChat((HumanEntity)player, lines));
    }

    public static void clearChat(HumanEntity player) {
        player.sendMessage(ChatUtils.newlineArray());
    }

    public static void clearChat(HumanEntity player, Integer lines) {
        player.sendMessage(ChatUtils.newlineArray(0, lines));
    }

    public static void send(String content) {
        ChatUtils.message(content).send();
    }

    public static MessageBuilder message(String content) {
        return new MessageBuilder((Component)Component.text((String)content));
    }

    public static MessageBuilder message(Component content) {
        return new MessageBuilder(content);
    }

    public static List<String> getExitKeywords() {
        return Arrays.asList("EXIT", "E", "X");
    }

    public static List<String> getConfirmKeywords() {
        return Arrays.asList("CONFIRM", "C");
    }

    public static boolean isExitKeyword(String keyword) {
        return ChatUtils.getExitKeywords().contains(keyword.toUpperCase());
    }

    public static Boolean isConfirmKeyword(String keyword) {
        return ChatUtils.getConfirmKeywords().contains(keyword.toUpperCase());
    }

    public static String shortenString(String string, Integer targetLength) {
        return string.length() > targetLength - 1 ? string.substring(0, targetLength) + "..." : string;
    }

    public static class MessageBuilder {
        private Component content;
        private MessageType type = MessageType.NOTIF;
        private MessageTarget target = MessageTarget.WORLD;
        private MessageStyle style = MessageStyle.PRETTY;
        private Player player = null;

        private MessageBuilder(Component content) {
            this.content = content;
        }

        public MessageBuilder content(Component baseMessage) {
            this.content = baseMessage;
            return this;
        }

        public MessageBuilder content(String baseMessage) {
            return this.content((Component)Component.text((String)baseMessage));
        }

        public Component getContent() {
            return this.content;
        }

        public MessageBuilder type(MessageType messageType) {
            this.type = messageType;
            return this;
        }

        public MessageBuilder target(MessageTarget messageTarget) {
            this.target = messageTarget;
            return this;
        }

        public MessageBuilder player(Player player) {
            this.target = MessageTarget.PLAYER;
            this.player = player;
            return this;
        }

        public MessageBuilder style(MessageStyle messageStyle) {
            this.style = messageStyle;
            return this;
        }

        public void send() {
            Component formattedMessage = this.style.formatMessage(this.content, this.type);
            this.target.send(formattedMessage, (HumanEntity)this.player);
        }
    }

    public static enum MessageStyle {
        PRETTY{

            @Override
            public Component formatMessage(Component content, MessageType type) {
                return ((TextComponent)((TextComponent)Component.empty().appendNewline()).append((Component)Component.text((String)(type.prefix + ": ")))).append(content.color((TextColor)type.color));
            }
        }
        ,
        SIMPLE{

            @Override
            public Component formatMessage(Component content, MessageType type) {
                return ((TextComponent)Component.text((String)(type.prefix + ": ")).append(content)).color((TextColor)type.color);
            }
        }
        ,
        PLAIN{

            @Override
            public Component formatMessage(Component content, MessageType type) {
                return Component.text((String)(type.prefix + ": ")).append(content);
            }
        };


        public abstract Component formatMessage(Component var1, MessageType var2);
    }

    public static enum MessageTarget {
        CONSOLE{

            @Override
            public void send(Component formattedMessage, @Nullable HumanEntity player) {
                Bukkit.getConsoleSender().sendMessage(formattedMessage);
            }
        }
        ,
        WORLD{

            @Override
            public void send(Component formattedMessage, @Nullable HumanEntity player) {
                Bukkit.broadcast((Component)formattedMessage);
            }
        }
        ,
        PLAYER{

            @Override
            public void send(Component formattedMessage, @Nullable HumanEntity player) {
                if (player == null) {
                    ChatUtils.message("MessageTarget.PLAYER did not pass in player, for message: " + String.valueOf(formattedMessage)).type(MessageType.ERROR).send();
                    new Exception().printStackTrace();
                    return;
                }
                player.sendMessage(formattedMessage);
            }
        };


        public abstract void send(Component var1, @Nullable HumanEntity var2);
    }

    public static enum MessageType {
        NOTIF("[PlayerQuests]", NamedTextColor.GRAY),
        WARN("[PlayerQuests] \u26a0 Help", NamedTextColor.YELLOW),
        ERROR("[PlayerQuests] \ud83d\udeab Error", NamedTextColor.RED);

        private final String prefix;
        private final NamedTextColor color;

        private MessageType(String prefix, NamedTextColor color) {
            this.prefix = prefix;
            this.color = color;
        }
    }
}

