/*
 * Decompiled with CFR 0.152.
 */
package playerquests.utility;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import playerquests.Core;

public class FileUtils {
    private FileUtils() {
    }

    public static void create(String filename, byte[] content) throws IOException {
        File file = new File(Core.getPlugin().getDataFolder(), filename);
        try {
            Files.write(file.toPath(), content, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new IOException("Could not create the '" + filename + "' file.", e);
        }
    }

    public static String get(String filename) throws IOException {
        Path fullPath = new File(Core.getPlugin().getDataFolder(), filename).toPath();
        try {
            return Files.readString(fullPath);
        }
        catch (IOException e) {
            throw new IOException("Could not read the '" + filename + "' file.", e);
        }
    }

    public static void delete(String filename) throws IOException {
        Path fullPath = new File(Core.getPlugin().getDataFolder(), filename).toPath();
        try {
            Files.delete(fullPath);
        }
        catch (IOException e) {
            throw new IOException("Could not delete the '" + filename + "' file.", e);
        }
    }

    public static Boolean check(String filename) throws IOException {
        Path fullPath = new File(Core.getPlugin().getDataFolder(), filename).toPath();
        return Files.exists(fullPath, new LinkOption[0]);
    }

    public static void append(String filename, byte[] content) throws IOException {
        byte[] oldContent;
        Path fullPath = new File(Core.getPlugin().getDataFolder(), filename).toPath();
        try {
            oldContent = Files.readAllBytes(fullPath);
        }
        catch (IOException e) {
            oldContent = new byte[]{};
        }
        byte[] combinedContent = new byte[oldContent.length + content.length];
        System.arraycopy(oldContent, 0, combinedContent, 0, oldContent.length);
        System.arraycopy(content, 0, combinedContent, oldContent.length, content.length);
        try {
            Files.write(fullPath, combinedContent, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            throw new IOException("Could not write to the '" + filename + "' file.", e);
        }
    }
}

