/*
 * Decompiled with CFR 0.152.
 */
package playerquests.utility;

import java.util.HashMap;
import java.util.Map;
import playerquests.utility.ChatUtils;

public class MigrationUtils {
    private static final Map<String, String> MIGRATIONS = new HashMap<String, String>();

    private MigrationUtils() {
    }

    public static String getMigration(String version) {
        if (!MIGRATIONS.containsKey(version)) {
            throw new IllegalArgumentException("No migration query for version v" + version);
        }
        if ("0.10.4".equals(version)) {
            ChatUtils.message("Entities changed in this update, for all your quest files you need to change entity values from 'type:CHICKEN,color:black' to 'CHICKEN'; meaning, remove everything except the name of the entity.").style(ChatUtils.MessageStyle.PRETTY).type(ChatUtils.MessageType.WARN).target(ChatUtils.MessageTarget.WORLD).send();
        }
        return MIGRATIONS.get(version);
    }

    static {
        MIGRATIONS.put("0.4", "ALTER TABLE quests ADD COLUMN toggled TEXT DEFAULT true;");
        MIGRATIONS.put("0.5.1", "    -- Begin a transaction to ensure all operations are atomic\n    BEGIN TRANSACTION;\n\n    -- Drop temporary tables if they exist\n    DROP TABLE IF EXISTS temp_diary_quests;\n    DROP TABLE IF EXISTS temp_diaries;\n    DROP TABLE IF EXISTS temp_quests;\n    DROP TABLE IF EXISTS temp_players;\n\n    -- Create temporary tables for migration\n    CREATE TABLE temp_players (\n        uuid TEXT PRIMARY KEY NOT NULL\n    );\n\n    CREATE TABLE temp_quests (\n        id TEXT PRIMARY KEY NOT NULL\n    );\n\n    CREATE TABLE temp_diaries (\n        id TEXT PRIMARY KEY NOT NULL,\n        player TEXT UNIQUE,\n        FOREIGN KEY (player) REFERENCES temp_players(uuid)\n    );\n\n    CREATE TABLE temp_diary_quests (\n        id TEXT PRIMARY KEY NOT NULL,\n        stage TEXT NOT NULL,\n        action TEXT,\n        quest TEXT,\n        diary TEXT,\n        FOREIGN KEY (quest) REFERENCES temp_quests(id),\n        FOREIGN KEY (diary) REFERENCES temp_diaries(id)\n    );\n\n    -- Migrate data from old tables to temporary tables\n    INSERT INTO temp_players (uuid)\n    SELECT uuid FROM players;\n\n    INSERT INTO temp_quests (id)\n    SELECT id FROM quests;\n\n    INSERT INTO temp_diaries (id, player)\n    SELECT 'diary_' || p.uuid, p.uuid\n    FROM diaries AS d\n    JOIN players AS p ON d.player = p.id;\n\n    INSERT INTO temp_diary_quests (id, stage, action, quest, diary)\n    SELECT dq.id, dq.stage, dq.action, dq.quest, 'diary_' || p.uuid\n    FROM diary_quests AS dq\n    JOIN diaries AS d ON dq.diary = d.id\n    JOIN players AS p ON d.player = p.id;\n\n    -- Drop old tables\n    DROP TABLE IF EXISTS diary_quests;\n    DROP TABLE IF EXISTS diaries;\n    DROP TABLE IF EXISTS quests;\n    DROP TABLE IF EXISTS players;\n\n    -- Rename temporary tables to match new schema\n    ALTER TABLE temp_players RENAME TO players;\n    ALTER TABLE temp_quests RENAME TO quests;\n    ALTER TABLE temp_diaries RENAME TO diaries;\n    ALTER TABLE temp_diary_quests RENAME TO diary_quests;\n\n    -- Remove unused sequence tracking (next increments)\n    DELETE FROM sqlite_sequence WHERE name = 'diaries';\n    DELETE FROM sqlite_sequence WHERE name = 'players';\n\n    -- Commit the transaction if everything is successful\n    COMMIT;\n");
        MIGRATIONS.put("0.7", "    -- Begin a transaction to ensure all operations are atomic\n    BEGIN TRANSACTION;\n\n    ALTER TABLE quests ADD COLUMN inventory TEXT NOT NULL DEFAULT \"{ }\"  ;\n\n    -- Commit the transaction if everything is successful\n    COMMIT;\n");
        MIGRATIONS.put("0.8", "    -- Begin a transaction to ensure all operations are atomic\n    BEGIN TRANSACTION;\n\n    DROP TABLE diary_quests;\n\n    -- Commit the transaction if everything is successful\n    COMMIT;\n");
        MIGRATIONS.put("0.10", "    BEGIN TRANSACTION;\n\n    ALTER TABLE plugin ADD COLUMN citizens2 BOOLEAN NOT NULL DEFAULT FALSE;\n\n    COMMIT;\n");
        MIGRATIONS.put("0.10.1", "    BEGIN TRANSACTION;\n\n    ALTER TABLE quests ADD COLUMN inventory TEXT NOT NULL DEFAULT \"\";\n\n    COMMIT;\n");
        MIGRATIONS.put("0.10.4", "    BEGIN TRANSACTION;\n\n    -- Create replacement plugin table\n    CREATE TABLE IF NOT EXISTS temp_plugin (\n        plugin TEXT PRIMARY KEY,\n        version TEXT NOT NULL,\n        CONSTRAINT single_row_constraint UNIQUE (plugin)\n    );\n\n    -- Migrate data from old plugib table to temporary plugin table\n    INSERT INTO temp_plugin (plugin, version)\n    SELECT plugin.plugin, plugin.version\n    FROM plugin;\n\n    -- Drop old plugin table\n    DROP TABLE IF EXISTS plugin;\n\n    -- Rename temporary tables to match new schema\n    ALTER TABLE temp_plugin RENAME TO plugin;\n\n    -- Commit the transaction if everything is successful\n    COMMIT;\n");
    }
}

