/*
 * Decompiled with CFR 0.152.
 */
package playerquests.utility;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.IntStream;
import org.bukkit.block.BlockFace;
import playerquests.product.Quest;
import playerquests.utility.serialisable.ItemSerialisable;

public class PluginUtils {
    protected static BlockFace[] orderedDirections = new BlockFace[]{BlockFace.NORTH, BlockFace.NORTH_NORTH_EAST, BlockFace.NORTH_EAST, BlockFace.EAST_NORTH_EAST, BlockFace.EAST, BlockFace.EAST_SOUTH_EAST, BlockFace.SOUTH_EAST, BlockFace.SOUTH_SOUTH_EAST, BlockFace.SOUTH, BlockFace.SOUTH_SOUTH_WEST, BlockFace.SOUTH_WEST, BlockFace.WEST_SOUTH_WEST, BlockFace.WEST, BlockFace.WEST_NORTH_WEST, BlockFace.NORTH_WEST, BlockFace.NORTH_NORTH_WEST};

    private PluginUtils() {
    }

    public static void validateParams(List<Object> params, Class<?> ... expectedTypes) throws IllegalArgumentException {
        Objects.requireNonNull(params, "Params cannot be null");
        if (params.size() != expectedTypes.length) {
            throw new IllegalArgumentException("Incorrect number of parameters");
        }
        IntStream.range(0, params.size()).filter(i -> !expectedTypes[i].isInstance(params.get(i))).findFirst().ifPresent(index -> {
            throw new IllegalArgumentException("Parameter at index " + index + " does not match the expected type");
        });
    }

    public static Map<ItemSerialisable, Integer> getPredictiveInventory(Quest quest, Map<ItemSerialisable, Integer> inventory) {
        LinkedHashMap<ItemSerialisable, Integer> predictiveInventory = new LinkedHashMap<ItemSerialisable, Integer>();
        Map<ItemSerialisable, Integer> requiredInventory = quest.getRequiredInventory();
        if (requiredInventory != null) {
            requiredInventory.forEach((item, amount) -> predictiveInventory.merge((ItemSerialisable)item, -amount.intValue(), Integer::sum));
        }
        if (inventory != null) {
            inventory.forEach((item, amount) -> predictiveInventory.merge((ItemSerialisable)item, (Integer)amount, Integer::sum));
        }
        return predictiveInventory;
    }

    public static BlockFace getBlockFaceFromYaw(int yaw) {
        int normalizedYaw = (yaw % 360 + 360) % 360;
        if (normalizedYaw == 0) {
            return BlockFace.SELF;
        }
        int directionIndex = (normalizedYaw + 11) % 360 / 22;
        return orderedDirections[directionIndex];
    }

    public static int getYawFromBlockFace(BlockFace face) {
        Map blockFaceToYaw = Map.ofEntries(Map.entry(BlockFace.SELF, 0), Map.entry(BlockFace.NORTH_NORTH_EAST, 23), Map.entry(BlockFace.NORTH_EAST, 45), Map.entry(BlockFace.EAST_NORTH_EAST, 68), Map.entry(BlockFace.EAST, 90), Map.entry(BlockFace.EAST_SOUTH_EAST, 113), Map.entry(BlockFace.SOUTH_EAST, 135), Map.entry(BlockFace.SOUTH_SOUTH_EAST, 158), Map.entry(BlockFace.SOUTH, 180), Map.entry(BlockFace.SOUTH_SOUTH_WEST, 203), Map.entry(BlockFace.SOUTH_WEST, 225), Map.entry(BlockFace.WEST_SOUTH_WEST, 248), Map.entry(BlockFace.WEST, 270), Map.entry(BlockFace.WEST_NORTH_WEST, 293), Map.entry(BlockFace.NORTH_WEST, 315), Map.entry(BlockFace.NORTH_NORTH_WEST, 338), Map.entry(BlockFace.NORTH, 360));
        return blockFaceToYaw.getOrDefault(face, 0);
    }
}

