/*
 * Decompiled with CFR 0.152.
 */
package playerquests.utility.enums;

import playerquests.utility.ChatUtils;

public enum DependencyIssue {
    MISSING("install", "installing"){

        @Override
        public void sendMessage(String dependencyExplainer, String dependencyLink) {
            ChatUtils.message(String.join((CharSequence)" ", "Soft Dependency Reminder! \u2728\n", dependencyExplainer, this.linkSymbol, dependencyLink.strip())).target(ChatUtils.MessageTarget.WORLD).style(ChatUtils.MessageStyle.PRETTY).type(ChatUtils.MessageType.NOTIF).send();
        }

        @Override
        public String getRemedyVerb() {
            return "install";
        }
    }
    ,
    OUT_OF_DATE("update", "updating"){

        @Override
        public void sendMessage(String dependencyExplainer, String dependencyLink) {
            ChatUtils.message(String.join((CharSequence)" ", "A Dependency Requires Updating! \u2728\n", dependencyExplainer, this.linkSymbol, dependencyLink.strip())).target(ChatUtils.MessageTarget.WORLD).style(ChatUtils.MessageStyle.PRETTY).type(ChatUtils.MessageType.ERROR).send();
        }
    }
    ,
    TOO_NEW("downgrade", "downgrading"){

        @Override
        public void sendMessage(String dependencyExplainer, String dependencyLink) {
            ChatUtils.message(String.join((CharSequence)" ", "A Dependency Is Too New! \u2728\n", dependencyExplainer, this.linkSymbol, dependencyLink.strip())).target(ChatUtils.MessageTarget.WORLD).style(ChatUtils.MessageStyle.PRETTY).type(ChatUtils.MessageType.ERROR).send();
        }
    };

    protected final String linkSymbol = "\ud83d\udd17";
    private final String remedyVerb;
    private final String remedyPresentPrinciple;

    private DependencyIssue(String remedyVerb, String remedyPresentPrinciple) {
        this.remedyVerb = remedyVerb;
        this.remedyPresentPrinciple = remedyPresentPrinciple;
    }

    public abstract void sendMessage(String var1, String var2);

    public String getRemedyVerb() {
        return this.remedyVerb;
    }

    public String getRemedyPresentPrinciple() {
        return this.remedyPresentPrinciple;
    }
}

