/*
 * Decompiled with CFR 0.152.
 */
package playerquests.utility.listener;

import io.papermc.paper.event.packet.PlayerChunkLoadEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import playerquests.Core;
import playerquests.builder.quest.action.QuestAction;
import playerquests.builder.quest.npc.BlockNPC;
import playerquests.builder.quest.npc.QuestNPC;
import playerquests.client.quest.QuestClient;
import playerquests.utility.event.NPCInteractEvent;
import playerquests.utility.singleton.QuestRegistry;

public class BlockListener
implements Listener {
    private Map<Player, Boolean> canQuesterRefreshNPCs = new HashMap<Player, Boolean>();

    public BlockListener() {
        Bukkit.getPluginManager().registerEvents((Listener)this, Core.getPlugin());
    }

    public void unsetBlockNPC(BlockNPC blockNPC, Player player) {
        Location npcLocation = blockNPC.getNPC().getLocation().toBukkitLocation();
        BlockData emptyBlockData = Material.AIR.createBlockData();
        player.sendBlockChange(npcLocation, emptyBlockData);
    }

    @EventHandler
    public void onChunkLoad(PlayerChunkLoadEvent event) {
        List<QuestClient> allQuesters = QuestRegistry.getInstance().getAllQuesters();
        if (allQuesters.isEmpty()) {
            return;
        }
        Player player = event.getPlayer();
        if (allQuesters.stream().noneMatch(quester -> quester.getPlayer().equals((Object)player))) {
            return;
        }
        boolean state = this.canQuesterRefreshNPCs.getOrDefault(player, true);
        if (!state) {
            return;
        }
        QuestClient quester2 = Core.getQuestRegistry().getQuester(player);
        this.canQuesterRefreshNPCs.put(player, false);
        Bukkit.getScheduler().runTaskLater(Core.getPlugin(), () -> {
            List<Map.Entry> npcs = quester2.getData().getNPCs().stream().filter(npc -> ((QuestNPC)npc.getValue()).getAssigned() instanceof BlockNPC).filter(npc -> ((QuestNPC)npc.getValue()).getLocation().toBukkitLocation().getChunk().isLoaded()).toList();
            npcs.forEach(npc -> {
                BlockNPC blockNPC = (BlockNPC)((QuestNPC)npc.getValue()).getAssigned();
                blockNPC.spawn((QuestAction)npc.getKey(), quester2);
            });
            this.canQuesterRefreshNPCs.put(player, true);
        }, 600L);
    }

    @EventHandler
    public void onBlockNPCInteract(PlayerInteractEvent event) {
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        Location eventBlockLocation = block.getLocation();
        QuestClient quester = Core.getQuestRegistry().getQuester(event.getPlayer());
        List<Map.Entry<QuestAction<?, ?>, QuestNPC>> npcs = quester.getData().getNPCs().stream().filter(npc -> ((QuestNPC)npc.getValue()).getAssigned() instanceof BlockNPC).filter(npc -> ((QuestNPC)npc.getValue()).getLocation().toBukkitLocation().equals((Object)eventBlockLocation)).toList();
        if (!npcs.isEmpty()) {
            event.setCancelled(true);
        }
        Bukkit.getScheduler().runTask(Core.getPlugin(), () -> npcs.forEach(npc -> {
            BlockNPC blockNPC = (BlockNPC)((QuestNPC)npc.getValue()).getAssigned();
            blockNPC.spawn((QuestAction)npc.getKey(), quester);
        }));
        if (npcs.isEmpty() || event.getHand().equals((Object)EquipmentSlot.OFF_HAND) || !event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
            return;
        }
        Bukkit.getServer().getPluginManager().callEvent((Event)new NPCInteractEvent(npcs, event.getPlayer()));
    }
}

