/*
 * Decompiled with CFR 0.152.
 */
package playerquests.utility.listener;

import java.util.List;
import java.util.Map;
import net.citizensnpcs.api.event.NPCRightClickEvent;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import playerquests.Core;
import playerquests.builder.quest.action.QuestAction;
import playerquests.builder.quest.npc.QuestNPC;
import playerquests.client.quest.QuestClient;
import playerquests.utility.event.NPCInteractEvent;
import playerquests.utility.event.PlayerInteractEvent;
import playerquests.utility.singleton.PlayerQuests;

public class EntityListener
implements Listener {
    public EntityListener() {
        if (PlayerQuests.getInstance().hasCitizens2()) {
            Bukkit.getPluginManager().registerEvents((Listener)this, Core.getPlugin());
        }
    }

    @EventHandler
    public void onEntityNPCInteract(NPCRightClickEvent event) {
        NPC citizen = event.getNPC();
        if (citizen == null) {
            return;
        }
        QuestClient quester = Core.getQuestRegistry().getQuester(event.getClicker());
        List<Map.Entry<QuestAction<?, ?>, QuestNPC>> npcs = quester.getData().getNPCs().stream().filter(npc -> citizen.equals((Object)quester.getData().getCitizenNPC((QuestAction)npc.getKey(), (QuestNPC)npc.getValue()))).toList();
        if (npcs.isEmpty()) {
            return;
        }
        Bukkit.getServer().getPluginManager().callEvent((Event)new NPCInteractEvent(npcs, event.getClicker()));
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEntityEvent event) {
        if (!(event.getRightClicked() instanceof Player)) {
            return;
        }
        Player clickedPlayer = (Player)event.getRightClicked();
        Bukkit.getServer().getPluginManager().callEvent((Event)new PlayerInteractEvent(clickedPlayer, event.getPlayer()));
    }
}

