/*
 * Decompiled with CFR 0.152.
 */
package playerquests.utility.listener;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import playerquests.Core;
import playerquests.utility.ChatUtils;
import playerquests.utility.singleton.Database;

public class PlayerListener
implements Listener {
    private boolean isFresh = false;

    public PlayerListener() {
        Bukkit.getPluginManager().registerEvents((Listener)this, Core.getPlugin());
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        Bukkit.getScheduler().runTaskLater(Core.getPlugin(), () -> {
            Core.getQuestRegistry().createQuester(player);
            if (this.isFresh) {
                ChatUtils.message(((TextComponent)((TextComponent)((TextComponent)Component.empty().append(Component.text((String)"Thank you for trying PlayerQuests, use ").color((TextColor)NamedTextColor.GRAY))).append(Component.text((String)"/playerquests ").color((TextColor)NamedTextColor.AQUA))).append(Component.text((String)"to get started. You can also find a tutorial here! ").color((TextColor)NamedTextColor.GRAY))).append(Component.text((String)("https://sammypanda.moe/docs/playerquests/v" + Database.getInstance().getPluginVersion())).decorate(TextDecoration.UNDERLINED))).player(player).style(ChatUtils.MessageStyle.PRETTY).type(ChatUtils.MessageType.NOTIF).send();
            }
        }, 60L);
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent event) {
        Core.getQuestRegistry().removeQuester(event.getPlayer());
    }

    public void isFresh() {
        this.isFresh = true;
    }
}

