/*
 * Decompiled with CFR 0.152.
 */
package playerquests.utility.serialisable.data;

import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.keys.ChickenVariantKeys;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.trait.versioned.ChickenTrait;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import playerquests.Core;
import playerquests.utility.ChatUtils;
import playerquests.utility.serialisable.EntitySerialisable;
import playerquests.utility.serialisable.data.DataWrapper;
import playerquests.utility.serialisable.keys.EntityDataKeys;
import playerquests.utility.singleton.PlayerQuests;

public enum EntityData implements DataWrapper<Entity, NPC, EntityType>
{
    GENERIC{

        @Override
        public NPC create(Map<String, String> properties) {
            NPC citizen = this.createNPC(properties).orElseThrow();
            Bukkit.getScheduler().runTask(Core.getPlugin(), () -> {
                if (citizen.isSpawned()) {
                    this.warnUnimplemented(citizen.getEntity().getType());
                }
            });
            return citizen;
        }

        @Override
        public Map<String, String> extractProperties(Entity entity) {
            return this.basicProperties(entity, Map.of(this.getTypeKey(), entity.getType().name()));
        }

        @Override
        public String getName(Map<String, String> properties) {
            return this.formatText(properties.get(this.getTypeKey()));
        }

        @Override
        public boolean includes(EntityType type) {
            return true;
        }

        @Override
        public EntityType getEntityType(Map<String, String> properties) {
            EntityType entityType;
            try {
                entityType = EntityType.valueOf((String)properties.getOrDefault(this.getTypeKey(), "VILLAGER"));
            }
            catch (Exception e) {
                entityType = EntityType.VILLAGER;
            }
            return entityType;
        }

        public EntitySerialisable getFallback() {
            return new EntitySerialisable("VILLAGER");
        }
    }
    ,
    CHICKEN{

        @Override
        public NPC create(Map<String, String> properties) throws IllegalArgumentException {
            NPC citizen = this.createNPC(properties).orElseThrow();
            Chicken.Variant variant = Optional.ofNullable((Chicken.Variant)RegistryAccess.registryAccess().getRegistry(RegistryKey.CHICKEN_VARIANT).get(ChickenVariantKeys.create((Key)Key.key((String)properties.getOrDefault("variant", "temperate"))))).orElse(Chicken.Variant.TEMPERATE);
            ((ChickenTrait)citizen.getOrAddTrait(ChickenTrait.class)).setVariant(variant);
            return citizen;
        }

        @Override
        public Map<String, String> extractProperties(Entity entity) {
            Chicken chicken = (Chicken)entity;
            Chicken.Variant variant = chicken.getVariant();
            return this.basicProperties(entity, Map.of("variant", variant.getKey().asMinimalString()));
        }

        @Override
        public String getName(Map<String, String> properties) {
            return this.formatText(EntityType.CHICKEN.name());
        }

        @Override
        public boolean includes(EntityType type) {
            return type == EntityType.CHICKEN;
        }

        @Override
        public EntityType getEntityType(Map<String, String> properties) {
            return EntityType.CHICKEN;
        }

        public EntitySerialisable getFallback() {
            return new EntitySerialisable("GENERIC[entity:CHICKEN]");
        }
    }
    ,
    VILLAGER{

        @Override
        public NPC create(Map<String, String> properties) throws IllegalArgumentException {
            return this.createNPC(properties).orElseThrow();
        }

        @Override
        public Map<String, String> extractProperties(Entity entity) {
            return this.basicProperties(entity, Map.of());
        }

        @Override
        public String getName(Map<String, String> properties) {
            return this.formatText(EntityType.VILLAGER.name());
        }

        @Override
        public boolean includes(EntityType type) {
            return type == EntityType.VILLAGER;
        }

        @Override
        public EntityType getEntityType(Map<String, String> properties) {
            return EntityType.VILLAGER;
        }

        public EntitySerialisable getFallback() {
            return new EntitySerialisable("GENERIC[entity:VILLAGER]");
        }
    }
    ,
    PLAYER{

        @Override
        public NPC create(Map<String, String> properties) throws IllegalArgumentException {
            return this.createNPC(properties).orElseThrow();
        }

        @Override
        public Map<String, String> extractProperties(Entity entity) {
            Player player = (Player)entity;
            return this.basicProperties(entity, Map.of(EntityDataKeys.PLAYER_NAME.getKey(), player.getName()));
        }

        @Override
        public String getName(Map<String, String> properties) {
            return properties.getOrDefault(EntityDataKeys.PLAYER_NAME.getKey(), "Player");
        }

        @Override
        public boolean includes(EntityType type) {
            return type == EntityType.PLAYER;
        }

        @Override
        public EntityType getEntityType(Map<String, String> properties) {
            return EntityType.PLAYER;
        }

        public EntitySerialisable getFallback() {
            return new EntitySerialisable("VILLAGER");
        }
    };

    private static final Set<EntityType> warnedEntities;

    @Override
    public Set<EntityType> getWarnedTypes() {
        return warnedEntities;
    }

    @Override
    public Map<EntityType, DataWrapper<Entity, NPC, EntityType>> getSpecialMappings() {
        EnumMap<EntityType, DataWrapper<Entity, NPC, EntityType>> specialMappings = new EnumMap<EntityType, DataWrapper<Entity, NPC, EntityType>>(EntityType.class);
        specialMappings.put(EntityType.CHICKEN, CHICKEN);
        specialMappings.put(EntityType.VILLAGER, VILLAGER);
        specialMappings.put(EntityType.PLAYER, PLAYER);
        return specialMappings;
    }

    Map<String, String> basicProperties(Entity entity, Map<String, String> properties) {
        return properties;
    }

    protected Optional<NPC> createNPC(Map<String, String> properties) {
        try {
            String name = properties.getOrDefault(EntityDataKeys.PLAYER_NAME.getKey(), "");
            EntityType entityType = this.getEntityType(properties);
            NPC citizen = PlayerQuests.getInstance().getCitizensRegistry().createNPC(entityType, name);
            return Optional.of(citizen);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public NPC spawn(Map<String, String> properties, Location location) throws IllegalArgumentException {
        NPC citizen = (NPC)this.create(properties);
        citizen.spawn(location);
        return citizen;
    }

    public static EntityData getEnum(String string) {
        Optional<EntityData> entityDataMatch = Arrays.stream(EntityData.values()).filter(e -> !e.equals(GENERIC)).filter(e -> e.name().equalsIgnoreCase(string)).findFirst();
        if (entityDataMatch.isPresent()) {
            return entityDataMatch.get();
        }
        ChatUtils.message("Unknown entity type: " + string + ". Defaulting to VILLAGER. \ud83d\udc94").target(ChatUtils.MessageTarget.CONSOLE).type(ChatUtils.MessageType.ERROR).style(ChatUtils.MessageStyle.PRETTY).send();
        return VILLAGER;
    }

    @Override
    public String getTypeKey() {
        return "entity";
    }

    @Override
    public DataWrapper<Entity, NPC, EntityType> getGenericHandler() {
        return GENERIC;
    }

    public abstract EntityType getEntityType(Map<String, String> var1);

    static {
        warnedEntities = Collections.synchronizedSet(new HashSet());
    }
}

