/*
 * Decompiled with CFR 0.152.
 */
package playerquests.utility.serialisable.data;

import com.destroystokyo.paper.profile.PlayerProfile;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.BlockItemDataProperties;
import io.papermc.paper.datacomponent.item.ResolvableProfile;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.keys.EnchantmentKeys;
import io.papermc.paper.registry.keys.TrimMaterialKeys;
import io.papermc.paper.registry.keys.TrimPatternKeys;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Skull;
import org.bukkit.block.TileState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Rotatable;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ArmorMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.inventory.meta.trim.ArmorTrim;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.potion.PotionType;
import playerquests.utility.ChatUtils;
import playerquests.utility.FetchUtils;
import playerquests.utility.PluginUtils;
import playerquests.utility.serialisable.ItemSerialisable;
import playerquests.utility.serialisable.data.DataWrapper;
import playerquests.utility.serialisable.keys.ItemDataKeys;

public enum ItemData implements DataWrapper<ItemStack, ItemStack, Material>
{
    GENERIC{

        @Override
        public ItemStack create(Map<String, String> properties) {
            String typeKey = properties.getOrDefault(this.getTypeKey(), "GRAY_WOOL");
            Material material = ItemData.tryGetMaterialEnum(typeKey);
            this.warnUnimplemented(material);
            return ItemData.basicItem(new ItemStack(material), properties);
        }

        @Override
        public Map<String, String> extractProperties(ItemStack source) {
            return ItemData.basicProperties(source, Map.of(this.getTypeKey(), source.getType().name()));
        }

        @Override
        public String getName(Map<String, String> properties) {
            return this.formatText(properties.get(this.getTypeKey()));
        }

        @Override
        public boolean includes(Material type) {
            return true;
        }

        public ItemSerialisable getFallback() {
            return new ItemSerialisable("DIRT");
        }

        @Override
        public Map<String, String> fromBlockState(BlockState block) {
            ItemSerialisable fallbackItemSerialisable = (ItemSerialisable)GENERIC.getFallback();
            Material material = Optional.of(block.getType()).orElse(fallbackItemSerialisable.toItemStack().getType());
            return Map.of(ItemDataKeys.TYPE.getKey(), material.toString());
        }
    }
    ,
    POTION{

        @Override
        public ItemStack create(Map<String, String> properties) {
            Material material = ItemData.tryGetMaterialEnum("POTION");
            ItemStack item = new ItemStack(material);
            if (material == Material.POTION) {
                PotionMeta meta = (PotionMeta)item.getItemMeta();
                PotionType type = PotionType.valueOf((String)properties.getOrDefault("type", "WATER").toUpperCase());
                meta.setBasePotionType(type);
                item.setItemMeta((ItemMeta)meta);
            }
            return ItemData.basicItem(item, properties);
        }

        @Override
        public Map<String, String> extractProperties(ItemStack source) {
            PotionMeta potionMeta;
            ItemMeta itemMeta;
            HashMap<String, String> props = new HashMap<String, String>();
            PotionMeta meta = source != null && (itemMeta = source.getItemMeta()) instanceof PotionMeta ? (potionMeta = (PotionMeta)itemMeta) : null;
            PotionType type = meta != null && meta.getBasePotionType() != null ? meta.getBasePotionType() : PotionType.values()[0];
            props.put("type", type.name());
            return ItemData.basicProperties(source, props);
        }

        @Override
        public String getName(Map<String, String> properties) {
            if (!properties.containsKey("type")) {
                return "Potion";
            }
            PotionType type = PotionType.valueOf((String)properties.get("type"));
            return this.formatText(type.toString() + " Potion");
        }

        @Override
        public boolean includes(Material type) {
            return type.equals((Object)Material.POTION);
        }

        public ItemSerialisable getFallback() {
            return new ItemSerialisable("GENERIC[material:POTION]");
        }

        @Override
        public Map<String, String> fromBlockState(BlockState block) {
            return Map.of();
        }
    }
    ,
    WOOL{
        private static String colorKey = "color";
        private static String woolSuffix = "_WOOL";

        @Override
        public ItemStack create(Map<String, String> properties) {
            String color = properties.getOrDefault(colorKey, "WHITE");
            Material material = ItemData.tryGetMaterialEnum(color + woolSuffix);
            return ItemData.basicItem(new ItemStack(material), properties);
        }

        @Override
        public Map<String, String> extractProperties(ItemStack item) {
            String color = item.getType().name().replace(woolSuffix, "");
            return ItemData.basicProperties(item, Map.of(colorKey, color));
        }

        @Override
        public String getName(Map<String, String> properties) {
            if (!properties.containsKey(colorKey)) {
                return "Wool";
            }
            return this.formatText(properties.get(colorKey) + " Wool");
        }

        @Override
        public boolean includes(Material m) {
            return m.name().endsWith(woolSuffix);
        }

        public ItemSerialisable getFallback() {
            return new ItemSerialisable("GENERIC[material:WHITE_WOOL]");
        }

        @Override
        public Map<String, String> fromBlockState(BlockState block) {
            return Map.of();
        }
    }
    ,
    PLAYER_HEAD{

        @Override
        public ItemStack create(Map<String, String> properties) {
            Material material = ItemData.tryGetMaterialEnum("PLAYER_HEAD");
            if (material != Material.PLAYER_HEAD) {
                throw new IllegalStateException();
            }
            ItemStack item = new ItemStack(material);
            Optional.ofNullable(properties.get(ItemDataKeys.PLAYER_NAME.getKey())).ifPresent(value -> {
                SkullMeta meta = (SkullMeta)item.getItemMeta();
                OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)value);
                PlayerProfile playerProfile = offlinePlayer.getPlayerProfile();
                if (!playerProfile.complete()) {
                    ChatUtils.message("Failed to get the user profile for " + value).target(ChatUtils.MessageTarget.CONSOLE).type(ChatUtils.MessageType.ERROR).style(ChatUtils.MessageStyle.SIMPLE).send();
                }
                meta.setOwningPlayer(offlinePlayer);
                meta.setPlayerProfile(playerProfile);
                item.setItemMeta((ItemMeta)meta);
            });
            return ItemData.basicItem(item, properties);
        }

        @Override
        public Map<String, String> extractProperties(ItemStack item) {
            SkullMeta skullMeta;
            ItemMeta itemMeta;
            HashMap<String, String> props = new HashMap<String, String>();
            SkullMeta meta = item != null && (itemMeta = item.getItemMeta()) instanceof SkullMeta ? (skullMeta = (SkullMeta)itemMeta) : null;
            String playerName = meta != null && meta.hasOwner() ? meta.getOwningPlayer().getName() : "UNKNOWN";
            props.put(ItemDataKeys.PLAYER_NAME.getKey(), playerName);
            return ItemData.basicProperties(item, props);
        }

        @Override
        public String getName(Map<String, String> properties) {
            if (!properties.containsKey(ItemDataKeys.PLAYER_NAME.getKey())) {
                return "Player Head";
            }
            return this.formatText(properties.get(ItemDataKeys.PLAYER_NAME.getKey()) + " Head");
        }

        @Override
        public boolean includes(Material m) {
            return m.equals((Object)Material.PLAYER_HEAD);
        }

        public ItemSerialisable getFallback() {
            return new ItemSerialisable("ZOMBIE_HEAD");
        }

        @Override
        public BlockData getBlockData(Map<String, String> properties) {
            BlockData blockData = Material.PLAYER_HEAD.createBlockData();
            String xRotationRaw = properties.get(ItemDataKeys.ROTATION_X.getKey());
            if (xRotationRaw != null && blockData instanceof Rotatable) {
                Rotatable rotatableBlockData = (Rotatable)blockData;
                Integer xRotation = Optional.of(Integer.parseInt(xRotationRaw)).orElse(0);
                BlockFace blockFace = PluginUtils.getBlockFaceFromYaw(xRotation);
                rotatableBlockData.setRotation(blockFace);
            }
            return blockData;
        }

        @Override
        public BlockState getBlockState(Map<String, String> properties, BlockData blockData) {
            BlockState blockState = blockData.createBlockState();
            String playerValue = properties.get(ItemDataKeys.PLAYER_NAME.getKey());
            if (playerValue != null && blockState instanceof Skull) {
                Skull skullState = (Skull)blockState;
                skullState.setProfile(ResolvableProfile.resolvableProfile((PlayerProfile)FetchUtils.getProfileFromUsername(playerValue)));
            }
            return blockState;
        }

        @Override
        public void sendBlockUpdate(Map<String, String> properties, BlockData blockData, Player player, Location location) {
            Skull skull = (Skull)PLAYER_HEAD.getBlockState(properties, blockData);
            player.sendBlockUpdate(location, (TileState)skull);
        }

        @Override
        public Map<String, String> fromBlockState(BlockState block) {
            BlockData blockData;
            HashMap<String, String> properties = new HashMap<String, String>();
            if (block instanceof Skull) {
                Skull skullBlockState = (Skull)block;
                Optional.ofNullable(skullBlockState.getProfile()).ifPresent(playerName -> properties.put(ItemDataKeys.PLAYER_NAME.getKey(), playerName.name()));
            }
            if ((blockData = block.getBlockData()) instanceof Rotatable) {
                Rotatable rotatableBlockData = (Rotatable)blockData;
                BlockFace rotation = rotatableBlockData.getRotation();
                properties.put(ItemDataKeys.ROTATION_X.getKey(), String.valueOf(PluginUtils.getYawFromBlockFace(rotation)));
            }
            return properties;
        }
    }
    ,
    SOUP{
        private static String soupSuffix = "_SOUP";
        private static String stewSuffix = "_STEW";
        private static String flavourKey = "flavour";

        @Override
        public ItemStack create(Map<String, String> properties) {
            String flavour = properties.getOrDefault(flavourKey, "BEETROOT");
            Material material = ItemData.tryGetMaterialEnum(flavour + soupSuffix);
            return ItemData.basicItem(new ItemStack(material), properties);
        }

        @Override
        public Map<String, String> extractProperties(ItemStack item) {
            String flavour = item.getType().name().replace(soupSuffix, "");
            flavour = flavour.replace(stewSuffix, "");
            return ItemData.basicProperties(item, Map.of(flavourKey, flavour));
        }

        @Override
        public String getName(Map<String, String> properties) {
            if (!properties.containsKey(flavourKey)) {
                return "Soup";
            }
            return this.formatText(properties.get(flavourKey) + " Soup");
        }

        @Override
        public boolean includes(Material m) {
            return m.name().endsWith(soupSuffix) || m.name().endsWith(stewSuffix);
        }

        public ItemSerialisable getFallback() {
            return new ItemSerialisable("MUSHROOM_STEW");
        }

        @Override
        public Map<String, String> fromBlockState(BlockState block) {
            return Map.of();
        }
    }
    ,
    AIR{

        @Override
        public ItemStack create(Map<String, String> properties) {
            Material material = 6.tryGetMaterialEnum("AIR");
            return new ItemStack(material);
        }

        @Override
        public Map<String, String> extractProperties(ItemStack item) {
            return Map.of();
        }

        @Override
        public String getName(Map<String, String> properties) {
            return "Air";
        }

        @Override
        public boolean includes(Material m) {
            return m.equals((Object)Material.AIR);
        }

        public ItemSerialisable getFallback() {
            return new ItemSerialisable("GENERIC[material:AIR]");
        }

        @Override
        public Map<String, String> fromBlockState(BlockState block) {
            return Map.of();
        }
    }
    ,
    CHAIN{
        private static String chainSuffix = "_CHAIN";
        private static String typeKey = "type";

        @Override
        public ItemStack create(Map<String, String> properties) {
            String type = properties.getOrDefault(typeKey, "IRON");
            Material material = ItemData.tryGetMaterialEnum(type + chainSuffix);
            return ItemData.basicItem(new ItemStack(material), properties);
        }

        @Override
        public Map<String, String> extractProperties(ItemStack source) {
            String type = source.getType().name().replace(chainSuffix, "");
            return ItemData.basicProperties(source, Map.of(typeKey, type));
        }

        @Override
        public String getName(Map<String, String> properties) {
            if (!properties.containsKey(typeKey)) {
                return "Chain";
            }
            return this.formatText(properties.get(typeKey) + " Chain");
        }

        @Override
        public boolean includes(Material type) {
            return type.name().endsWith(chainSuffix);
        }

        public ItemSerialisable getFallback() {
            return new ItemSerialisable("GENERIC[material:CHAIN]");
        }

        @Override
        public Map<String, String> fromBlockState(BlockState block) {
            return Map.of();
        }
    };

    private static String materialTypeKey;
    private static String enchantmentKey;
    private static String nametagKey;
    private static String trimPatternKey;
    private static String trimMaterialKey;
    private static final Set<Material> warnedMaterials;

    @Override
    public Set<Material> getWarnedTypes() {
        return warnedMaterials;
    }

    @Override
    public Map<Material, DataWrapper<ItemStack, ItemStack, Material>> getSpecialMappings() {
        EnumMap<Material, DataWrapper<ItemStack, ItemStack, Material>> specialMappings = new EnumMap<Material, DataWrapper<ItemStack, ItemStack, Material>>(Material.class);
        specialMappings.put(Material.POTION, POTION);
        specialMappings.put(Material.SPLASH_POTION, POTION);
        specialMappings.put(Material.LINGERING_POTION, POTION);
        Arrays.stream(Material.values()).filter(WOOL::includes).forEach(m -> specialMappings.put((Material)m, WOOL));
        specialMappings.put(Material.PLAYER_HEAD, PLAYER_HEAD);
        Arrays.stream(Material.values()).filter(SOUP::includes).forEach(m -> specialMappings.put((Material)m, SOUP));
        return specialMappings;
    }

    public static ItemData getEnum(String string) {
        Optional<ItemData> itemDataMatch = Arrays.stream(ItemData.values()).filter(e -> !e.equals(GENERIC)).filter(e -> e.name().equalsIgnoreCase(string)).findFirst();
        if (itemDataMatch.isPresent()) {
            return itemDataMatch.get();
        }
        ChatUtils.message("Unknown item type: " + string + ". Defaulting to AIR. \ud83d\udc94").target(ChatUtils.MessageTarget.CONSOLE).type(ChatUtils.MessageType.ERROR).style(ChatUtils.MessageStyle.PRETTY).send();
        return AIR;
    }

    public static Material tryGetMaterialEnum(String materialString) {
        try {
            return Material.valueOf((String)materialString);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            return Material.RED_WOOL;
        }
    }

    private static ItemStack basicItem(ItemStack itemStack, Map<String, String> properties) {
        if (properties.containsKey(enchantmentKey)) {
            Integer level;
            String enchantmentString = properties.get(enchantmentKey);
            List<String> enchantmentStringParts = List.of(enchantmentString.split("_"));
            try {
                level = Integer.parseInt(enchantmentStringParts.getLast());
            }
            catch (Exception e) {
                level = 0;
            }
            String enchantmentType = String.join((CharSequence)"_", enchantmentStringParts.removeLast());
            Enchantment enchantment = (Enchantment)RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT).get(EnchantmentKeys.create((Key)Key.key((String)enchantmentType)));
            if (enchantment != null) {
                itemStack.addEnchantment(enchantment, level.intValue());
            }
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (properties.containsKey(nametagKey)) {
            String nametagString = properties.get(nametagKey);
            itemMeta.displayName((Component)Component.text((String)nametagString));
            itemStack.setItemMeta(itemMeta);
        }
        if (properties.containsKey(trimPatternKey) && properties.containsKey(trimMaterialKey)) {
            String trimPatternString = properties.get(trimPatternKey).toLowerCase();
            String trimMaterialString = properties.get(trimMaterialKey).toLowerCase();
            ArmorMeta armorMeta = (ArmorMeta)itemMeta;
            TrimPattern trimPattern = (TrimPattern)RegistryAccess.registryAccess().getRegistry(RegistryKey.TRIM_PATTERN).getOrThrow(TrimPatternKeys.create((Key)Key.key((String)trimPatternString)));
            TrimMaterial trimMaterial = (TrimMaterial)RegistryAccess.registryAccess().getRegistry(RegistryKey.TRIM_MATERIAL).getOrThrow(TrimMaterialKeys.create((Key)Key.key((String)trimMaterialString)));
            armorMeta.setTrim(new ArmorTrim(trimMaterial, trimPattern));
            itemStack.setItemMeta((ItemMeta)armorMeta);
        }
        return itemStack;
    }

    private static Map<String, String> basicProperties(ItemStack itemStack, Map<String, String> properties) {
        ArmorMeta armorMeta;
        List<Material> trimCapable;
        HashMap<String, String> newProperties = new HashMap<String, String>(properties);
        Map enchantments = itemStack.getEnchantments();
        enchantments.forEach((enchantment, level) -> newProperties.put(enchantmentKey, String.join((CharSequence)"_", enchantment.getKey().asString(), String.valueOf(level))));
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta.hasDisplayName()) {
            newProperties.put(nametagKey, PlainTextComponentSerializer.plainText().serialize(itemStack.getItemMeta().displayName()));
        }
        if ((trimCapable = List.of(Material.NETHERITE_BOOTS, Material.NETHERITE_HELMET, Material.NETHERITE_CHESTPLATE, Material.NETHERITE_LEGGINGS)).contains(itemStack.getType()) && (armorMeta = (ArmorMeta)itemMeta).hasTrim()) {
            ArmorTrim armorTrim = armorMeta.getTrim();
            String trimPatternString = RegistryAccess.registryAccess().getRegistry(RegistryKey.TRIM_PATTERN).getKey((Keyed)armorTrim.getPattern()).getKey();
            String trimMaterialString = RegistryAccess.registryAccess().getRegistry(RegistryKey.TRIM_MATERIAL).getKey((Keyed)armorTrim.getMaterial()).getKey();
            newProperties.put(trimPatternKey, trimPatternString);
            newProperties.put(trimMaterialKey, trimMaterialString);
        }
        return newProperties;
    }

    @Override
    public String getTypeKey() {
        return materialTypeKey;
    }

    public static String getNametagKey() {
        return nametagKey;
    }

    public static String getEnchantmentKey() {
        return enchantmentKey;
    }

    @Override
    public DataWrapper<ItemStack, ItemStack, Material> getGenericHandler() {
        return GENERIC;
    }

    public Block spawn(Map<String, String> properties, Location location) {
        ItemStack itemStack = (ItemStack)this.create(properties);
        Material material = itemStack.getType();
        if (!material.isBlock()) {
            throw new IllegalArgumentException("Tried to spawn an ItemData " + this.toString() + ", which is not a valid block.");
        }
        Block block = location.getBlock();
        BlockItemDataProperties blockItemDataProperties = (BlockItemDataProperties)itemStack.getData(DataComponentTypes.BLOCK_DATA);
        block.setType(material);
        if (!itemStack.hasData((DataComponentType)DataComponentTypes.BLOCK_DATA)) {
            this.warnUnimplemented(material);
            return block;
        }
        blockItemDataProperties.applyTo(block.getBlockData());
        return block;
    }

    public BlockState getBlockState(Map<String, String> properties, BlockData blockData) {
        return blockData.createBlockState();
    }

    public BlockData getBlockData(Map<String, String> properties) {
        return ((ItemStack)this.create(properties)).getType().createBlockData();
    }

    public abstract Map<String, String> fromBlockState(BlockState var1);

    public void sendBlockUpdate(Map<String, String> properties, BlockData blockData, Player player, Location location) {
        BlockState blockState = this.getBlockState(properties, blockData);
        if (blockState instanceof TileState) {
            TileState tileState = (TileState)blockState;
            player.sendBlockUpdate(location, tileState);
        }
    }

    static {
        materialTypeKey = "material";
        enchantmentKey = "enchantment";
        nametagKey = "nametag";
        trimPatternKey = "trimPattern";
        trimMaterialKey = "trimMaterial";
        warnedMaterials = Collections.synchronizedSet(new HashSet());
    }
}

