/*
 * Decompiled with CFR 0.152.
 */
package playerquests.utility.singleton;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.npc.NPCDataStore;
import net.citizensnpcs.api.npc.NPCRegistry;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import playerquests.Core;
import playerquests.client.Director;
import playerquests.product.Quest;
import playerquests.utility.ChatUtils;
import playerquests.utility.enums.DependencyIssue;
import playerquests.utility.listener.BlockListener;
import playerquests.utility.listener.EntityListener;
import playerquests.utility.listener.PlayerListener;
import playerquests.utility.listener.ServerListener;
import playerquests.utility.singleton.Database;
import playerquests.utility.singleton.QuestRegistry;

public class PlayerQuests {
    private static final Database database = Database.getInstance();
    private static final PlayerQuests instance = new PlayerQuests();
    private static final BlockListener blockListener = new BlockListener();
    private static final EntityListener entityListener = new EntityListener();
    private static final PlayerListener playerListener = new PlayerListener();
    private static final ServerListener serverListener = new ServerListener();
    private Map<String, Boolean> dependencies = new HashMap<String, Boolean>();
    private NPCRegistry citizensRegistry;
    private List<Director> directors = new ArrayList<Director>();

    private PlayerQuests() {
    }

    public static PlayerQuests getInstance() {
        return instance;
    }

    public static Plugin getCitizens2() {
        return Bukkit.getServer().getPluginManager().getPlugin("Citizens");
    }

    public NPCRegistry getCitizensRegistry() {
        if (!this.hasCitizens2()) {
            throw new IllegalAccessError("Tried to access CitizensRegistry without Citizens");
        }
        try {
            if (this.citizensRegistry == null) {
                Class<?> memoryNPCDataStoreClass = Class.forName("net.citizensnpcs.api.npc.MemoryNPCDataStore");
                Object dataStore = memoryNPCDataStoreClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.citizensRegistry = CitizensAPI.createNamedNPCRegistry((String)"playerquests", (NPCDataStore)((NPCDataStore)dataStore));
            }
            return this.citizensRegistry;
        }
        catch (Exception e) {
            throw new NoSuchMethodError("Failed to initialize Citizens registry");
        }
    }

    public boolean hasCitizens2() {
        Boolean mappedSupport = this.dependencies.get("Citizens2");
        if (mappedSupport != null) {
            return mappedSupport;
        }
        boolean isSupported = false;
        DependencyIssue dependencyIssue = DependencyIssue.MISSING;
        if (PlayerQuests.getCitizens2() != null) {
            String[] versionParts = PlayerQuests.getCitizens2().getPluginMeta().getVersion().split("\\D+");
            Integer majorVersion = Integer.parseInt(versionParts[0]);
            Integer minorVersion = Integer.parseInt(versionParts[1]);
            Integer patchVersion = Integer.parseInt(versionParts[2]);
            String expectedVersion = null;
            Integer expectedMajorVersion = majorVersion;
            Integer expectedMinorVersion = minorVersion;
            Integer expectedPatchVersion = patchVersion;
            try (InputStream input = this.getClass().getResourceAsStream("/plugin.properties");){
                Properties props = new Properties();
                props.load(input);
                expectedVersion = props.getProperty("expectedCitizensVersion");
                String[] expectedVersionParts = expectedVersion.split("\\.");
                expectedMajorVersion = Integer.parseInt(expectedVersionParts[0]);
                expectedMinorVersion = Integer.parseInt(expectedVersionParts[1]);
                expectedPatchVersion = Integer.parseInt(expectedVersionParts[2]);
            }
            catch (Exception e) {
                ChatUtils.message("POM.XML is missing the expected citizensFlatVersion (got " + expectedVersion + ") for this PlayerQuests release, please report this to sammypanda").type(ChatUtils.MessageType.ERROR).style(ChatUtils.MessageStyle.PRETTY).target(ChatUtils.MessageTarget.CONSOLE).send();
            }
            boolean isSameMajor = majorVersion.equals(expectedMajorVersion);
            boolean isHigherMinor = minorVersion > expectedMinorVersion;
            boolean isSameMinor = minorVersion.equals(expectedMinorVersion);
            boolean isPatchSufficient = patchVersion >= expectedPatchVersion;
            boolean bl = isSupported = isSameMajor && (isHigherMinor || isSameMinor && isPatchSufficient);
            if (!isSupported && majorVersion <= expectedMajorVersion) {
                dependencyIssue = DependencyIssue.OUT_OF_DATE;
            }
            if (majorVersion > expectedMajorVersion) {
                dependencyIssue = DependencyIssue.TOO_NEW;
            }
        }
        if (!isSupported) {
            dependencyIssue.sendMessage("To unlock all the NPC types, consider " + dependencyIssue.getRemedyPresentPrinciple() + " Citizens! Without it, some NPC types will be unavailable. <3", "https://ci.citizensnpcs.co/job/Citizens2/");
        }
        this.dependencies.put("Citizens2", isSupported);
        return isSupported;
    }

    public static Database getDatabase() {
        return database;
    }

    public static BlockListener getBlockListener() {
        return blockListener;
    }

    public static EntityListener getEntityListener() {
        return entityListener;
    }

    public static PlayerListener getPlayerListener() {
        return playerListener;
    }

    public static ServerListener getServerListener() {
        return serverListener;
    }

    public static void remove(Quest quest) {
        Core.getQuestRegistry().getAllQuesters().forEach(quester -> quester.getDiary().remove(quest));
    }

    public static void install(Quest quest) {
        quest.getNPCs().values().forEach(npc -> npc.setQuest(quest));
        Core.getQuestRegistry().getAllQuesters().forEach(quester -> quester.getDiary().add(quest));
    }

    public void addDirector(Director director) {
        this.directors.add(director);
    }

    public void clear() {
        QuestRegistry.getInstance().getAllQuesters().forEach(quester -> quester.clear());
        if (PlayerQuests.getInstance().hasCitizens2()) {
            this.getCitizensRegistry().despawnNPCs(DespawnReason.REMOVAL);
            CitizensAPI.removeNamedNPCRegistry((String)"playerquests");
        }
        QuestRegistry.getInstance().clear();
        this.directors.removeIf(director -> {
            director.close();
            return true;
        });
    }

    public static void reload() {
        ChatUtils.message("Reloading PlayerQuests").style(ChatUtils.MessageStyle.PRETTY).type(ChatUtils.MessageType.WARN).target(ChatUtils.MessageTarget.WORLD).send();
        HashMap<String, Quest> questsCopy = new HashMap<String, Quest>(QuestRegistry.getInstance().getAllQuests());
        questsCopy.forEach((questTitle, quest) -> {
            ChatUtils.message("% Cycling " + questTitle).style(ChatUtils.MessageStyle.PLAIN).target(ChatUtils.MessageTarget.WORLD).type(ChatUtils.MessageType.NOTIF).send();
            QuestRegistry.getInstance().delete((Quest)quest, false, false, false);
        });
        PlayerQuests.getServerListener().processQuests();
    }
}

