/*
 * Decompiled with CFR 0.152.
 */
package playerquests.utility.singleton;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import moe.sammypanda.playerquests.bukkit.Metrics;
import moe.sammypanda.playerquests.charts.DrilldownPie;
import moe.sammypanda.playerquests.charts.SingleLineChart;
import playerquests.CitizensVersionFetcher;
import playerquests.Core;
import playerquests.utility.singleton.PlayerQuests;
import playerquests.utility.singleton.QuestRegistry;

public class PlayerQuestsMetrics {
    private static PlayerQuestsMetrics instance;
    private Metrics metrics = new Metrics(Core.getPlugin(), 22692);

    private PlayerQuestsMetrics() {
        this.addCustomCharts();
    }

    public static PlayerQuestsMetrics getInstance() {
        if (instance == null) {
            instance = new PlayerQuestsMetrics();
        }
        return instance;
    }

    private void addCustomCharts() {
        this.metrics.addCustomChart(new DrilldownPie("citizensVersion", () -> {
            HashMap<String, Map<String, Integer>> result = new HashMap<String, Map<String, Integer>>();
            if (!PlayerQuests.getInstance().hasCitizens2()) {
                result.put("Not Installed", Map.of("N/A", 1));
                return result;
            }
            String rawVersion = PlayerQuests.getCitizens2().getPluginMeta().getVersion();
            String baseVersion = CitizensVersionFetcher.cleanRawVersion(rawVersion);
            Optional<String> matchedVersion = CitizensVersionFetcher.findMatchingVersionInResources(baseVersion);
            String displayVersion = matchedVersion.map(CitizensVersionFetcher::formatDisplayVersion).orElse("Custom/Unknown: " + baseVersion);
            String drilldownVersion = matchedVersion.orElse("Custom/Unknown: " + rawVersion);
            result.put(displayVersion, Map.of(drilldownVersion, 1));
            return result;
        }));
        this.metrics.addCustomChart(new SingleLineChart("totalQuestCount", () -> QuestRegistry.getInstance().getAllQuests().size()));
    }
}

