/*
 * Decompiled with CFR 0.152.
 */
package playerquests;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.InputStream;
import java.lang.reflect.InaccessibleObjectException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import playerquests.Core;

public class CitizensVersionFetcher {
    private static final Logger logger = Logger.getLogger(CitizensVersionFetcher.class.getName());
    private static final HttpClient httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();
    private static final ObjectMapper mapper = new ObjectMapper();

    public static void main(String[] args) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        Path output = Path.of("src/main/resources/citizens_versions.json", new String[0]);
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://api.spiget.org/v2/resources/13811/versions?size=5000&sort=-releaseDate&fields=name")).timeout(Duration.ofSeconds(15L)).header("Accept", "application/json").GET().build();
        HttpResponse<String> response = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() != 200) {
            logger.warning(() -> "\u26a0\ufe0f API returned status: " + response.statusCode());
            throw new InaccessibleObjectException("API returned a non-200 status");
        }
        ArrayNode versions = (ArrayNode)mapper.readTree(response.body());
        ArrayNode filtered = mapper.createArrayNode();
        HashSet uniqueVersions = new HashSet();
        versions.forEach(v -> {
            String fullName = v.path("name").asText();
            String baseVersion = fullName.split("[\\s()]+")[0];
            if (CitizensVersionFetcher.isValidVersion(baseVersion) && uniqueVersions.add(baseVersion)) {
                filtered.add(mapper.createObjectNode().put("name", baseVersion));
            }
        });
        String filteredStringified = mapper.writerWithDefaultPrettyPrinter().writeValueAsString(filtered);
        Files.writeString(output, (CharSequence)filteredStringified, new OpenOption[0]);
        logger.info("\u2705 Successfully updated Citizens versions");
        logger.info(filteredStringified);
    }

    public static boolean isValidVersion(String version) {
        if (version == null || version.isEmpty()) {
            return false;
        }
        int dotCount = 0;
        for (int i = 0; i < version.length(); ++i) {
            char c = version.charAt(i);
            if (!(c == '.' ? i == 0 || i == version.length() - 1 || ++dotCount > 2 : !Character.isDigit(c))) continue;
            return false;
        }
        return dotCount >= 1;
    }

    public static String determineDisplayVersion(String baseVersion) {
        if (!CitizensVersionFetcher.isValidVersion(baseVersion)) {
            return "Custom/Unknown";
        }
        Optional<String> matchedVersion = CitizensVersionFetcher.findMatchingVersionInResources(baseVersion);
        return matchedVersion.map(CitizensVersionFetcher::formatDisplayVersion).orElseGet(() -> CitizensVersionFetcher.createDefaultDisplayVersion(baseVersion));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<String> findMatchingVersionInResources(String baseVersion) {
        try (InputStream is = CitizensVersionFetcher.class.getResourceAsStream("/citizens_versions.json");){
            JsonNode node;
            String ver;
            if (is == null) {
                Optional<String> optional = Optional.empty();
                return optional;
            }
            JsonNode versions = mapper.readTree(is);
            if (!versions.isArray()) return Optional.empty();
            Iterator<JsonNode> iterator = versions.iterator();
            do {
                if (!iterator.hasNext()) return Optional.empty();
            } while (!(ver = (node = iterator.next()).path("name").asText()).equals(baseVersion));
            Optional<String> optional = Optional.of(ver);
            return optional;
        }
        catch (Exception e) {
            Core.getPlugin().getLogger().log(Level.WARNING, "Error checking Citizens versions", e);
        }
        return Optional.empty();
    }

    public static String formatDisplayVersion(String version) {
        return version.startsWith("1.") ? "Citizens v1" : "Citizens v" + version.split("\\.")[0];
    }

    public static String createDefaultDisplayVersion(String baseVersion) {
        return CitizensVersionFetcher.formatDisplayVersion(baseVersion);
    }

    public static String cleanRawVersion(String version) {
        if (version == null || version.trim().isEmpty()) {
            return "Unknown";
        }
        Matcher m = Pattern.compile("(\\d+(?:\\.\\d+){1,2})").matcher(version);
        if (m.find()) {
            return m.group();
        }
        return version;
    }
}

