/*
 * Decompiled with CFR 0.152.
 */
package playerquests;

import java.lang.reflect.InvocationTargetException;
import org.bukkit.NamespacedKey;
import org.bukkit.command.PluginCommandYamlParser;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import playerquests.utility.singleton.PlayerQuests;
import playerquests.utility.singleton.PlayerQuestsMetrics;
import playerquests.utility.singleton.QuestRegistry;

public class Core
extends JavaPlugin {
    private static Plugin plugin;
    private static QuestRegistry questRegistry;
    private static String questsPath;
    private static String questsExtension;

    public void onEnable() {
        Core.setPlugin(this);
        PlayerQuests.getInstance();
        PluginCommandYamlParser.parse((Plugin)plugin).forEach(command -> {
            try {
                Class.forName("playerquests.client.chat.command.Command" + command.getName()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
        });
        PlayerQuestsMetrics.getInstance();
    }

    private static void setPlugin(Core core) {
        plugin = core;
    }

    public void onDisable() {
        PlayerQuests.getServerListener().onDisable();
    }

    public static Plugin getPlugin() {
        return plugin;
    }

    public static QuestRegistry getQuestRegistry() {
        return questRegistry;
    }

    public static String getQuestsPath() {
        return questsPath;
    }

    public static String getQuestFileExtension() {
        return questsExtension;
    }

    public static NamespacedKey getGUIKey() {
        return new NamespacedKey(plugin, "GUI");
    }

    static {
        questRegistry = QuestRegistry.getInstance();
        questsPath = "quests/";
        questsExtension = ".json";
    }
}

