/*
 * Decompiled with CFR 0.152.
 */
package playerquests.builder.gui.component;

import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import playerquests.builder.gui.GUIBuilder;
import playerquests.builder.gui.function.GUIFunction;
import playerquests.utility.ChatUtils;
import playerquests.utility.serialisable.ItemSerialisable;
import playerquests.utility.serialisable.data.ItemData;

public class GUISlot {
    private GUIBuilder builder;
    private Integer position;
    private ItemSerialisable item = new ItemSerialisable("GRAY_STAINED_GLASS_PANE");
    private Component label = Component.text((String)" ");
    private List<Component> description = List.of();
    private List<GUIFunction> functionList = new ArrayList<GUIFunction>();
    private Boolean errored = false;
    private Runnable onClick;
    private Integer stackCount = 1;
    private Boolean glinting = false;

    public GUISlot(GUIBuilder builder, Integer slotPosition) {
        this.builder = builder;
        this.setPosition(slotPosition);
    }

    public GUISlot addFunction(GUIFunction guiFunction) {
        this.functionList.add(guiFunction);
        return this;
    }

    public GUISlot setPosition(Integer position) {
        this.position = position;
        this.builder.setSlot(position, this);
        return this;
    }

    public Integer getPosition() {
        return this.position;
    }

    public GUISlot setItem(ItemSerialisable item) {
        if (item.getData().equals(ItemData.AIR)) {
            this.errored = true;
            this.item = new ItemSerialisable("RED_STAINED_GLASS_PANE");
            ChatUtils.message("Failed to setItem in GUISlot " + String.valueOf(item)).target(ChatUtils.MessageTarget.CONSOLE).type(ChatUtils.MessageType.ERROR).style(ChatUtils.MessageStyle.SIMPLE).send();
            return this;
        }
        this.item = item;
        return this;
    }

    public GUISlot setLabel(Component label, boolean italicSensitive) {
        Component errorLabel;
        TextComponent errorPrefix = Component.text((String)"(Error)");
        if (!italicSensitive) {
            label = label.decoration(TextDecoration.ITALIC, false);
        }
        if (!this.hasError()) {
            this.label = label;
            return this;
        }
        this.label = errorLabel = Component.join((JoinConfiguration)JoinConfiguration.separator((ComponentLike)Component.space()), (ComponentLike[])new ComponentLike[]{errorPrefix, label});
        return this;
    }

    public GUISlot setLabel(Component label) {
        this.setLabel(label, false);
        return this;
    }

    public GUISlot setLabel(String string) {
        this.setLabel((Component)Component.text((String)string), false);
        return this;
    }

    public GUISlot setLabel(String string, Boolean italicSensitive) {
        this.setLabel((Component)Component.text((String)string), (boolean)italicSensitive);
        return this;
    }

    public boolean hasError() {
        return this.errored;
    }

    public ItemSerialisable getItem() {
        return this.item;
    }

    public Component getLabel() {
        return this.label;
    }

    public void execute(Player player) {
        if (this.functionList.isEmpty()) {
            return;
        }
        GUIFunction function = this.functionList.get(0);
        function.execute();
    }

    public void executeNext(Player player) {
        if (this.functionList.size() <= 1) {
            return;
        }
        this.functionList.remove(0);
        this.execute(player);
    }

    public GUISlot onClick(Runnable onClick) {
        this.onClick = onClick;
        return this;
    }

    public void clicked() {
        if (this.onClick != null) {
            this.onClick.run();
        }
    }

    public GUISlot setDescription(Component description) {
        TextComponent errorText = Component.text((String)"");
        if (!this.hasError()) {
            this.description = List.of(description);
            return this;
        }
        Component errorDescription = Component.join((JoinConfiguration)JoinConfiguration.separator((ComponentLike)Component.space()), (ComponentLike[])new ComponentLike[]{errorText, description});
        this.description = List.of(errorDescription);
        return this;
    }

    public List<Component> getDescription() {
        return this.description;
    }

    public void setCount(Integer count) {
        this.stackCount = count;
    }

    public Integer getCount() {
        return this.stackCount;
    }

    public GUISlot setGlinting(Boolean glinting) {
        this.glinting = glinting;
        return this;
    }

    public boolean isGlinting() {
        return this.glinting;
    }

    public GUISlot setItem(Material material) {
        this.item = ItemSerialisable.fromItemStack(new ItemStack(material));
        return this;
    }

    public GUISlot setDescription(List<String> description) {
        this.description = description.stream().map(string -> Component.text((String)string)).toList();
        return this;
    }
}

