/*
 * Decompiled with CFR 0.152.
 */
package playerquests.builder.gui.dynamic;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.Material;
import playerquests.builder.gui.component.GUISlot;
import playerquests.builder.gui.dynamic.GUIDynamic;
import playerquests.builder.gui.function.UpdateScreen;
import playerquests.builder.quest.action.condition.ActionCondition;
import playerquests.builder.quest.action.condition.ConditionType;
import playerquests.builder.quest.data.ActionData;
import playerquests.client.ClientDirector;

public class Dynamicactionconditionselector
extends GUIDynamic {
    private ActionData actionData;

    public Dynamicactionconditionselector(ClientDirector director, String previousScreen) {
        super(director, previousScreen);
    }

    @Override
    protected void setupCustom() {
        this.actionData = (ActionData)this.director.getCurrentInstance(ActionData.class);
    }

    @Override
    protected void executeCustom() {
        this.gui.getFrame().setTitle("Select A Condition").setSize(9);
        new GUISlot(this.gui, 1).setLabel("Back").setItem(Material.OAK_DOOR).onClick(() -> new UpdateScreen(List.of(this.previousScreen), this.director).execute());
        new GUISlot(this.gui, 2).setItem(Material.GRAY_STAINED_GLASS_PANE);
        Consumer<ConditionType> createOptionButtons = conditionClass -> {
            ActionCondition condition;
            try {
                condition = conditionClass.getConditionClass().getDeclaredConstructor(ActionData.class).newInstance(this.actionData);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
                return;
            }
            condition.createSlot(this, this.gui, this.gui.getEmptySlot(), this.director).setDescription(condition.getDescription()).onClick(() -> {
                this.actionData.addCondition(condition);
                this.director.setCurrentInstance(condition, ActionCondition.class);
                new UpdateScreen(List.of("actionconditioneditor"), this.director).execute();
            });
        };
        Arrays.stream(ConditionType.values()).forEach(createOptionButtons);
    }
}

