/*
 * Decompiled with CFR 0.152.
 */
package playerquests.builder.gui.dynamic;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.bukkit.Material;
import playerquests.builder.gui.component.GUISlot;
import playerquests.builder.gui.dynamic.GUIDynamic;
import playerquests.builder.gui.function.ChatPrompt;
import playerquests.builder.gui.function.GUIFunction;
import playerquests.builder.gui.function.UpdateScreen;
import playerquests.builder.quest.action.QuestAction;
import playerquests.builder.quest.data.ActionData;
import playerquests.builder.quest.stage.QuestStage;
import playerquests.client.ClientDirector;
import playerquests.utility.ChatUtils;

public class Dynamicactioneditor
extends GUIDynamic {
    private QuestAction<?, ?> action;

    public Dynamicactioneditor(ClientDirector director, String previousScreen) {
        super(director, previousScreen);
    }

    @Override
    protected void setupCustom() {
        this.action = (QuestAction)this.director.getCurrentInstance(QuestAction.class);
    }

    @Override
    protected void executeCustom() {
        ActionData actionData = this.action.getData();
        this.gui.getFrame().setTitle(String.format("%s Editor", this.action.getLabel())).setSize(9);
        new GUISlot(this.gui, 1).setLabel("Back").setItem(Material.OAK_DOOR).onClick(() -> {
            this.director.setCurrentInstance(this.action.getStage());
            Optional<String> issueMessage = this.action.isValid();
            if (!issueMessage.isEmpty()) {
                ChatUtils.message(issueMessage.get()).style(ChatUtils.MessageStyle.PRETTY).type(ChatUtils.MessageType.WARN).player(this.director.getPlayer()).send();
                return;
            }
            new UpdateScreen(List.of(this.previousScreen), this.director).execute();
        });
        new GUISlot(this.gui, 2).setItem(Material.OAK_SIGN).setLabel(String.format("%s action label", this.action.hasLabel() ? "Change" : "Set")).onClick(() -> new ChatPrompt(Arrays.asList("Type a label to help you remember the action", "none"), this.director).onFinish((GUIFunction func) -> {
            ChatPrompt function = (ChatPrompt)func;
            String response = function.getResponse();
            this.action.setLabel(response);
            this.refresh();
        }).execute());
        new GUISlot(this.gui, 3).setItem(Material.HOPPER).setLabel("Next Actions").setDescription(List.of("Select actions to come after this one.")).onClick(() -> {
            this.director.setCurrentInstance(this.action);
            this.director.removeCurrentInstance(QuestStage.class);
            new UpdateScreen(Arrays.asList("nextactioneditor"), this.director).execute();
        });
        new GUISlot(this.gui, 4).setItem(Material.FIREWORK_ROCKET).setLabel("Change action type").setDescription(List.of(String.format("Currently: %s", this.action.getName()))).onClick(() -> {
            this.director.setCurrentInstance(this.action);
            new UpdateScreen(List.of("actiontypeselector"), this.director).execute();
        });
        if (!this.action.getOptions().isEmpty()) {
            new GUISlot(this.gui, 5).setItem(Material.STONE_BUTTON).setLabel("Edit action options").onClick(() -> {
                this.director.setCurrentInstance(actionData);
                new UpdateScreen(List.of("optioneditor"), this.director).execute();
            });
        }
        new GUISlot(this.gui, 6).setItem(Material.CLOCK).setLabel("Edit conditions").setDescription(List.of("Things like what times the", "action can be completed.")).onClick(() -> {
            this.director.setCurrentInstance(actionData);
            new UpdateScreen(List.of("actionconditions"), this.director).execute();
        });
        new GUISlot(this.gui, 9).setItem(Material.RED_DYE).setLabel("Delete action").onClick(() -> {
            Optional<String> issueMessage = this.action.delete();
            if (issueMessage.isEmpty()) {
                new UpdateScreen(List.of(this.previousScreen), this.director).execute();
                return;
            }
            ChatUtils.message(issueMessage.get()).style(ChatUtils.MessageStyle.PRETTY).type(ChatUtils.MessageType.WARN).player(this.director.getPlayer()).send();
        });
    }
}

