/*
 * Decompiled with CFR 0.152.
 */
package playerquests.builder.gui.dynamic;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Material;
import playerquests.builder.gui.component.GUISlot;
import playerquests.builder.gui.dynamic.GUIDynamic;
import playerquests.builder.gui.function.UpdateScreen;
import playerquests.builder.quest.action.QuestAction;
import playerquests.builder.quest.data.StagePath;
import playerquests.builder.quest.stage.QuestStage;
import playerquests.client.ClientDirector;
import playerquests.product.Quest;

public class Dynamicactionselector
extends GUIDynamic {
    Quest quest;
    QuestStage selectedStage;
    boolean stageSelection = true;
    List<StagePath> selectedActions = new ArrayList<StagePath>();

    public Dynamicactionselector(ClientDirector director, String previousScreen) {
        super(director, previousScreen);
    }

    @Override
    protected void setupCustom() {
        this.quest = (Quest)this.director.getCurrentInstance(Quest.class);
        this.selectedStage = (QuestStage)this.director.getCurrentInstance(QuestStage.class);
        List immutableSelectedActions = (List)this.director.getCurrentInstance(List.class);
        this.selectedActions = immutableSelectedActions.stream().collect(Collectors.toCollection(ArrayList::new));
        if (this.previousScreen.equals("queststage")) {
            this.stageSelection = false;
        }
    }

    @Override
    protected void executeCustom() {
        this.gui.getFrame().setTitle("Select Actions");
        if (this.selectedStage == null) {
            this.createBackButton();
            Map<String, QuestStage> stages = this.quest.getStages();
            stages.forEach((stageID, stage) -> this.createStageButton((QuestStage)stage));
        } else {
            this.createBackButton();
            List<QuestAction<?, ?>> actions = this.selectedStage.getOrderedActions();
            actions.forEach(this::createActionButton);
        }
    }

    private void createBackButton() {
        new GUISlot(this.gui, 1).setItem(Material.OAK_DOOR).setLabel("Back").onClick(() -> {
            if (this.selectedStage == null || !this.stageSelection) {
                new UpdateScreen(List.of(this.previousScreen), this.director).execute();
                this.finish();
            } else {
                this.director.removeCurrentInstance(QuestStage.class);
                this.refresh();
            }
        });
    }

    private GUISlot createStageButton(QuestStage stage) {
        return new GUISlot(this.gui, this.gui.getEmptySlot()).setLabel(stage.getLabel()).setItem(Material.CHEST).onClick(() -> {
            this.director.setCurrentInstance(stage, QuestStage.class);
            this.refresh();
        });
    }

    private GUISlot createActionButton(QuestAction<?, ?> action) {
        String actionID = action.getID();
        boolean isPresent = this.selectedActions.stream().anyMatch(p -> p.getStage().equals(action.getStage().getID()) && p.getActions().contains(actionID));
        return new GUISlot(this.gui, this.gui.getEmptySlot()).setLabel(String.format("%s%s", action.getLabel(), isPresent ? " (Selected)" : "")).setDescription(List.of(String.format("Type: %s", action.getName()))).setItem(isPresent ? Material.POWERED_RAIL : Material.RAIL).onClick(() -> {
            StagePath stagePath = new StagePath(action.getStage(), List.of(action));
            if (isPresent) {
                this.selectedActions.removeIf(p -> p.getActions().contains(actionID));
            } else {
                this.selectedActions.add(stagePath);
            }
            this.director.setCurrentInstance(this.selectedActions, List.class);
            this.refresh();
        });
    }

    public List<StagePath> getSelectedActions() {
        return this.selectedActions;
    }
}

