/*
 * Decompiled with CFR 0.152.
 */
package playerquests.builder.gui.dynamic;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import org.bukkit.Material;
import playerquests.builder.gui.component.GUISlot;
import playerquests.builder.gui.dynamic.GUIDynamic;
import playerquests.builder.gui.function.UpdateScreen;
import playerquests.builder.quest.action.QuestAction;
import playerquests.builder.quest.stage.QuestStage;
import playerquests.client.ClientDirector;
import playerquests.utility.ChatUtils;
import playerquests.utility.exception.MissingStageException;

public class Dynamicactiontypeselector
extends GUIDynamic {
    QuestAction<?, ?> action;
    List<QuestAction<?, ?>> actionTypes;
    QuestStage stage;

    public Dynamicactiontypeselector(ClientDirector director, String previousScreen) {
        super(director, previousScreen);
    }

    @Override
    protected void setupCustom() {
        this.action = (QuestAction)this.director.getCurrentInstance(QuestAction.class);
        this.stage = this.action.getStage();
        if (this.stage == null) {
            throw new MissingStageException("When changing action types, an action had a null stage.", new IllegalStateException("An action is missing a stage. All actions should belong to a stage."));
        }
        this.actionTypes = QuestAction.getAllTypes().stream().flatMap(actionClass -> {
            try {
                return Stream.of((QuestAction)actionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception e) {
                ChatUtils.message(e.getMessage()).target(ChatUtils.MessageTarget.CONSOLE).type(ChatUtils.MessageType.ERROR).send();
                return Stream.empty();
            }
        }).toList();
    }

    @Override
    protected void executeCustom() {
        int minimumSize = Math.clamp(Long.valueOf(this.actionTypes.size()) / 9L * 9L, 9, 54);
        this.gui.getFrame().setTitle(String.format("%s", "Available Action Types")).setSize(minimumSize);
        new GUISlot(this.gui, 1).setLabel("Back").setItem(Material.OAK_DOOR).addFunction(new UpdateScreen(Arrays.asList(this.previousScreen), this.director));
        this.actionTypes.forEach(actionType -> {
            GUISlot slot = actionType.createSlot(this.gui, this.gui.getEmptySlot());
            if (actionType.getClass().isAssignableFrom(this.action.getClass())) {
                slot.setLabel(Component.join((JoinConfiguration)JoinConfiguration.spaces(), (ComponentLike[])new ComponentLike[]{slot.getLabel(), Component.text((String)"(Selected)")})).setItem(Material.FIREWORK_ROCKET);
            }
            slot.onClick(() -> this.changeType(this.action, (QuestAction<?, ?>)actionType));
        });
    }

    private void changeType(QuestAction<?, ?> oldAction, QuestAction<?, ?> newAction) {
        this.action = this.stage.replaceAction(oldAction, newAction);
        this.director.setCurrentInstance(newAction, QuestAction.class);
        this.refresh();
    }
}

