/*
 * Decompiled with CFR 0.152.
 */
package playerquests.builder.gui.dynamic;

import java.util.Arrays;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import playerquests.builder.gui.component.GUISlot;
import playerquests.builder.gui.dynamic.GUIDynamic;
import playerquests.builder.gui.function.ChatPrompt;
import playerquests.builder.gui.function.GUIFunction;
import playerquests.client.ClientDirector;
import playerquests.utility.ChatUtils;

public class Dynamicitemeditor
extends GUIDynamic {
    ItemStack item;
    private Consumer<ItemStack> onUpdate;
    private Consumer<ItemStack> onRemove;

    public Dynamicitemeditor(ClientDirector director, String previousScreen) {
        super(director, previousScreen);
    }

    @Override
    protected void setupCustom() {
        this.item = (ItemStack)this.director.getCurrentInstance(ItemStack.class);
    }

    @Override
    protected void executeCustom() {
        Integer itemAmount = this.item.getAmount();
        this.gui.getFrame().setTitle("Edit " + this.item.getType().toString());
        new GUISlot(this.gui, 1).setItem(Material.OAK_DOOR).setLabel("Back").onClick(this::finish);
        new GUISlot(this.gui, 2).setItem(Material.BUCKET).setLabel(String.format("%s", itemAmount.equals(1) ? "Set amount" : "Change amount (" + itemAmount.toString() + ")")).onClick(() -> new ChatPrompt(Arrays.asList("Type a number under 65", "none"), this.director).onFinish((GUIFunction func) -> {
            Integer responseAsInteger;
            ChatPrompt function = (ChatPrompt)func;
            String response = function.getResponse();
            try {
                responseAsInteger = Integer.parseInt(response);
            }
            catch (NumberFormatException e) {
                responseAsInteger = null;
            }
            Player player = Bukkit.getPlayer((UUID)this.director.getPlayer().getUniqueId());
            ChatUtils.MessageBuilder err = ChatUtils.message("").player(player).type(ChatUtils.MessageType.WARN);
            if (responseAsInteger == null) {
                err.content("That might've been an invalid number.").send();
                return;
            }
            if (responseAsInteger > 64) {
                err.content("Make sure the amount is under 65.").send();
                return;
            }
            this.item.setAmount(responseAsInteger.intValue());
            this.execute();
            if (this.onUpdate != null) {
                this.onUpdate.accept(this.item);
            }
        }).execute());
        new GUISlot(this.gui, 9).setItem(Material.RED_DYE).setLabel("Delete").onClick(() -> this.onRemove.accept(this.item));
    }

    public ItemStack getResult() {
        return this.item;
    }

    public void onUpdate(Consumer<ItemStack> onUpdate) {
        this.onUpdate = onUpdate;
    }

    public void onRemove(Consumer<ItemStack> onRemove) {
        this.onRemove = onRemove;
    }
}

