/*
 * Decompiled with CFR 0.152.
 */
package playerquests.builder.gui.dynamic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import playerquests.builder.gui.component.GUISlot;
import playerquests.builder.gui.dynamic.Dynamicitemeditor;
import playerquests.builder.gui.dynamic.GUIDynamic;
import playerquests.builder.gui.function.GUIFunction;
import playerquests.builder.gui.function.SelectMaterial;
import playerquests.builder.gui.function.UpdateScreen;
import playerquests.client.ClientDirector;
import playerquests.utility.serialisable.ItemSerialisable;

public class Dynamicitemslist
extends GUIDynamic {
    List<ItemStack> items = new ArrayList<ItemStack>();
    private Map<ItemSerialisable, Integer> itemsDeDupe = new HashMap<ItemSerialisable, Integer>();
    Integer maxItems = 8;

    public Dynamicitemslist(ClientDirector director, String previousScreen) {
        super(director, previousScreen);
    }

    @Override
    protected void setupCustom() {
        ArrayList aList = (ArrayList)this.director.getCurrentInstance(ArrayList.class);
        if (aList != null) {
            this.setItems(aList.stream().filter(ItemStack.class::isInstance).map(ItemStack.class::cast).toList());
        }
    }

    @Override
    protected void executeCustom() {
        Integer listSize = this.items.size();
        this.gui.getFrame().setTitle("Item List");
        new GUISlot(this.gui, 1).setItem(Material.OAK_DOOR).setLabel("Back").onClick(() -> {
            this.director.removeCurrentInstance(ArrayList.class);
            this.finish();
            new UpdateScreen(Arrays.asList(this.previousScreen), this.director).execute();
        });
        if (!listSize.equals(this.maxItems)) {
            new GUISlot(this.gui, this.items.size() + 2).setItem(Material.LIME_DYE).setLabel("Add an item").onClick(() -> new SelectMaterial(Arrays.asList("Select or type a block", List.of(), List.of(), false), this.director).onFinish((GUIFunction func) -> {
                SelectMaterial function = (SelectMaterial)func;
                ItemStack result = function.getResult();
                this.gui.getResult().display();
                if (result == null) {
                    return;
                }
                this.addItem(result);
                this.execute();
            }).execute());
        }
        this.generateSlots(listSize);
    }

    private void generateSlots(Integer listSize) {
        IntStream.range(0, this.maxItems).anyMatch(index -> {
            if (listSize <= index) {
                return true;
            }
            ItemStack item = this.items.get(index);
            Integer itemCount = item.getAmount();
            String itemName = item.getType().toString();
            new GUISlot(this.gui, index + 2).setItem(ItemSerialisable.fromItemStack(item)).setLabel(itemName).setDescription(List.of(String.format("%s", itemCount.equals(1) ? "Press me to set quantity" : "Amount: " + itemCount.toString()))).onClick(() -> {
                this.director.setCurrentInstance(item);
                this.director.setCurrentInstance(this.items);
                new UpdateScreen(Arrays.asList("itemeditor"), this.director).onFinish((GUIFunction func) -> {
                    UpdateScreen function = (UpdateScreen)func;
                    Dynamicitemeditor editor = (Dynamicitemeditor)function.getDynamicGUI();
                    editor.onRemove(i -> {
                        this.removeItem((ItemStack)i);
                        this.goBack(function);
                    });
                    editor.onFinish(f -> this.goBack(function));
                }).execute();
            });
            return false;
        });
    }

    private void goBack(UpdateScreen function) {
        new UpdateScreen(new ArrayList<Object>(Arrays.asList(function.getPreviousScreen())), this.director).onFinish((GUIFunction f) -> {
            UpdateScreen nextfunction = (UpdateScreen)f;
            Dynamicitemslist list = (Dynamicitemslist)nextfunction.getDynamicGUI();
            list.setItems(this.getItems());
            list.onFinish(this.onFinish);
        }).execute();
    }

    private void setItems(List<ItemStack> items) {
        this.items = new ArrayList<ItemStack>();
        this.itemsDeDupe = new HashMap<ItemSerialisable, Integer>();
        items.forEach(this::addItem);
    }

    private void addItem(ItemStack item) {
        ItemSerialisable itemSerialiable = ItemSerialisable.fromItemStack(item);
        if (this.itemsDeDupe.containsKey(itemSerialiable)) {
            int index = this.itemsDeDupe.get(itemSerialiable);
            ItemStack existingItem = this.items.get(index);
            existingItem.add(item.getAmount());
            return;
        }
        this.items.add(item);
        this.itemsDeDupe.put(itemSerialiable, this.items.indexOf(item));
    }

    private void removeItem(ItemStack item) {
        this.items.remove(item);
    }

    public List<ItemStack> getItems() {
        return this.items;
    }
}

