/*
 * Decompiled with CFR 0.152.
 */
package playerquests.builder.gui.dynamic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.IntStream;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import playerquests.Core;
import playerquests.builder.gui.component.GUISlot;
import playerquests.builder.gui.dynamic.GUIDynamic;
import playerquests.builder.gui.function.UpdateScreen;
import playerquests.client.ClientDirector;
import playerquests.product.Quest;
import playerquests.utility.singleton.QuestRegistry;

public class Dynamicmyquests
extends GUIDynamic {
    private String guiTitle = "My Quests";
    private Set<String> myQuests = new LinkedHashSet<String>();
    private Integer lastBuiltSlot = 0;
    private Integer slotsPerPage = 36;
    private Integer invalidQuests = 0;
    private boolean myquestLoaded = false;

    public Dynamicmyquests(ClientDirector director, String previousScreen) {
        super(director, previousScreen);
    }

    @Override
    public void setupCustom() {
        if (!this.myquestLoaded) {
            CompletableFuture.runAsync(() -> this.myQuests.addAll(Core.getQuestRegistry().getAllQuests().keySet())).thenRun(() -> {
                this.myquestLoaded = true;
                Bukkit.getScheduler().runTask(Core.getPlugin(), () -> {
                    this.gui.clearSlots();
                    this.execute();
                });
            });
        }
    }

    @Override
    public void executeCustom() {
        Integer pageNumber = this.lastBuiltSlot / this.slotsPerPage + 1;
        this.gui.getFrame().setTitle(String.format("%s%s", this.guiTitle, pageNumber != 1 ? " [Page " + pageNumber + "]" : ""));
        new GUISlot(this.gui, 43).setItem(Material.RED_STAINED_GLASS).setLabel(String.format("Unreadable Quests: %s", this.invalidQuests >= 64 ? "(More than 64)" : this.invalidQuests)).setDescription(List.of("An unreadable quest, is a quest that is corrupt/malformed/incorrect.")).setCount(this.invalidQuests);
        this.gui.getFrame().setSize(45);
        if (this.myquestLoaded) {
            ArrayList<String> remainingQuests = new ArrayList<String>(this.myQuests.stream().filter(i -> new ArrayList<String>(this.myQuests).indexOf(i) > this.lastBuiltSlot - 1).toList());
            this.generatePage(remainingQuests);
        }
    }

    private void generatePage(ArrayList<String> remainingQuests) {
        this.generateExitButton();
        this.generateBackButton(remainingQuests);
        this.generateNextButton(remainingQuests);
        UUID playerUUID = this.director.getPlayer().getUniqueId();
        Integer slotCount = remainingQuests.size() >= this.slotsPerPage ? this.slotsPerPage.intValue() : remainingQuests.size();
        IntStream.range(0, slotCount).anyMatch(index -> this.generateQuestButton(playerUUID, index, remainingQuests));
    }

    private boolean generateQuestButton(UUID playerUUID, int index, ArrayList<String> remainingQuests) {
        List<Object> screen;
        if (remainingQuests.isEmpty() || remainingQuests.get(index) == null) {
            return true;
        }
        String questID = remainingQuests.get(index);
        Integer nextEmptySlot = this.gui.getEmptySlot();
        GUISlot questSlot = new GUISlot(this.gui, nextEmptySlot);
        Quest quest = QuestRegistry.getInstance().getQuest(questID);
        if (quest == null) {
            this.gui.removeSlot(nextEmptySlot);
            this.invalidQuests = this.invalidQuests + 1;
            return false;
        }
        if (!playerUUID.equals(quest.getCreator()) && quest.getCreator() != null) {
            this.gui.removeSlot(nextEmptySlot);
            return false;
        }
        if (quest == null || !quest.isValid()) {
            questSlot.setLabel(String.format("%s (Invalid)", quest.getTitle() != null ? quest.getTitle() : "Quest"));
            questSlot.setItem(Material.RED_STAINED_GLASS_PANE);
            return false;
        }
        questSlot.setLabel(questID.split("_")[0]);
        if (playerUUID.equals(quest.getCreator())) {
            screen = Arrays.asList("myquest");
            questSlot.setItem(Material.BOOK);
        } else {
            screen = Arrays.asList("theirquest");
            questSlot.setItem(Material.ENCHANTED_BOOK);
            questSlot.setLabel(questSlot.getLabel().append((Component)Component.text((String)" (Shared)")));
        }
        questSlot.onClick(() -> {
            this.director.setCurrentInstance(quest);
            new UpdateScreen(screen, this.director).execute();
        });
        return false;
    }

    private void generateNextButton(ArrayList<String> remainingQuests) {
        GUISlot nextButton = new GUISlot(this.gui, 45);
        if (this.slotsPerPage <= remainingQuests.size()) {
            nextButton.setLabel("Next");
            nextButton.setItem(Material.GREEN_STAINED_GLASS_PANE);
            nextButton.onClick(() -> {
                this.gui.clearSlots();
                this.lastBuiltSlot = this.lastBuiltSlot + this.slotsPerPage;
                this.execute();
            });
        }
    }

    private void generateBackButton(ArrayList<String> remainingQuests) {
        GUISlot backButton = new GUISlot(this.gui, 44);
        if (this.myQuests.size() != remainingQuests.size()) {
            backButton.setLabel("Back");
            backButton.setItem(Material.ORANGE_STAINED_GLASS_PANE);
            backButton.onClick(() -> {
                this.gui.clearSlots();
                this.lastBuiltSlot = this.lastBuiltSlot - this.slotsPerPage;
                this.execute();
            });
        }
    }

    private void generateExitButton() {
        GUISlot exitButton = new GUISlot(this.gui, 37);
        exitButton.setLabel("Back");
        exitButton.setItem(Material.OAK_DOOR);
        exitButton.addFunction(new UpdateScreen(Arrays.asList(this.previousScreen), this.director));
    }
}

