/*
 * Decompiled with CFR 0.152.
 */
package playerquests.builder.gui.dynamic;

import java.util.Arrays;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import playerquests.builder.gui.component.GUIFrame;
import playerquests.builder.gui.component.GUISlot;
import playerquests.builder.gui.dynamic.GUIDynamic;
import playerquests.builder.gui.function.UpdateScreen;
import playerquests.builder.quest.npc.EntityNPC;
import playerquests.builder.quest.npc.NPCType;
import playerquests.builder.quest.npc.QuestNPC;
import playerquests.client.ClientDirector;
import playerquests.utility.serialisable.EntitySerialisable;
import playerquests.utility.serialisable.ItemSerialisable;
import playerquests.utility.serialisable.data.EntityData;

public class Dynamicnpctypes
extends GUIDynamic {
    private QuestNPC npc;

    public Dynamicnpctypes(ClientDirector director, String previousScreen) {
        super(director, previousScreen);
    }

    @Override
    protected void setupCustom() {
        this.npc = (QuestNPC)this.director.getCurrentInstance(QuestNPC.class);
    }

    @Override
    protected void executeCustom() {
        GUIFrame frame = this.gui.getFrame();
        frame.setTitle(String.format("Assign %s to:", this.npc.getName() != null ? this.npc.getName() : "NPC"));
        GUISlot backButton = new GUISlot(this.gui, 1);
        backButton.setLabel("Back");
        backButton.setItem(Material.OAK_DOOR);
        backButton.addFunction(new UpdateScreen(Arrays.asList(this.previousScreen), this.director));
        GUISlot backDivider = new GUISlot(this.gui, 2);
        GUISlot placeDivider = new GUISlot(this.gui, 8);
        backDivider.setItem(Material.BLACK_STAINED_GLASS_PANE);
        placeDivider.setItem(Material.BLACK_STAINED_GLASS_PANE);
        NPCType.getAllTypes().stream().map(typeClass -> {
            try {
                return (NPCType)typeClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }).filter(Objects::nonNull).forEach(type -> type.createTypeSlot(this, this.director, this.gui, this.gui.getEmptySlot(), this.npc));
        boolean isPlayer = false;
        NPCType nPCType = this.npc.getAssigned();
        if (nPCType instanceof EntityNPC) {
            EntityNPC entityNPC = (EntityNPC)nPCType;
            isPlayer = entityNPC.getEntity().getData() == EntityData.PLAYER;
        }
        Player player = this.director.getPlayer();
        new GUISlot(this.gui, this.gui.getEmptySlot()).setLabel("Myself" + (isPlayer ? " (Selected)" : "")).setItem(new ItemSerialisable("PLAYER_HEAD[player:" + player.getName() + "]")).onClick(() -> {
            EntitySerialisable entitySerialisable = EntitySerialisable.fromEntity((Entity)player);
            this.npc.assign(new EntityNPC(entitySerialisable, this.npc));
            this.refresh();
        }).setDescription(Component.empty().append(Component.text((String)"Utilises Citizens2").color((TextColor)NamedTextColor.DARK_GRAY)));
        if (!this.npc.isAssigned()) {
            new GUISlot(this.gui, 9).setLabel("Cannot place before assigning").setItem(Material.BARRIER);
        } else {
            this.npc.getAssigned().createPlaceSlot(this, this.director, this.gui, 9, this.npc);
        }
    }
}

