/*
 * Decompiled with CFR 0.152.
 */
package playerquests.builder.gui.dynamic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Material;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import playerquests.builder.gui.component.GUIFrame;
import playerquests.builder.gui.component.GUISlot;
import playerquests.builder.gui.dynamic.GUIDynamic;
import playerquests.builder.gui.function.UpdateScreen;
import playerquests.client.ClientDirector;
import playerquests.product.Quest;
import playerquests.utility.PluginUtils;
import playerquests.utility.serialisable.ItemSerialisable;
import playerquests.utility.serialisable.data.ItemData;
import playerquests.utility.singleton.QuestRegistry;

public class Dynamicquestinventory
extends GUIDynamic {
    Map<ItemSerialisable, Integer> inventory = new HashMap<ItemSerialisable, Integer>();
    Quest quest;
    Map<ItemSerialisable, Integer> requiredInventory;

    public Dynamicquestinventory(ClientDirector director, String previousScreen) {
        super(director, previousScreen);
    }

    @Override
    protected void setupCustom() {
        this.quest = (Quest)this.director.getCurrentInstance(Quest.class);
    }

    @Override
    protected void executeCustom() {
        this.inventory = QuestRegistry.getInstance().getInventory(this.quest);
        this.requiredInventory = this.quest.getRequiredInventory();
        this.sortInventory();
        GUIFrame frame = this.gui.getFrame();
        frame.setSize(54);
        frame.setTitle("Quest Inventory/Stock");
        this.createBackButton(frame);
        this.createRestockButton(frame);
        new GUISlot(this.gui, 53).setItem(Material.GRAY_STAINED_GLASS_PANE).setLabel("Prev");
        new GUISlot(this.gui, 54).setItem(Material.GRAY_STAINED_GLASS_PANE).setLabel("Next");
        Map<ItemSerialisable, Integer> predictiveInventory = PluginUtils.getPredictiveInventory(this.quest, this.inventory);
        for (Map.Entry<ItemSerialisable, Integer> entry : predictiveInventory.entrySet()) {
            if (this.createInventorySlot(entry)) break;
        }
    }

    private void createBackButton(GUIFrame frame) {
        new GUISlot(this.gui, 1).setItem(Material.OAK_DOOR).setLabel("Back").onClick(() -> new UpdateScreen(Arrays.asList(this.previousScreen), this.director).execute());
    }

    private void createRestockButton(GUIFrame frame) {
        new GUISlot(this.gui, 52).setItem(Material.CHEST).setLabel("Restock").onClick(() -> {
            this.gui.clearSlots();
            frame.setTitle("Restock (Drag in items)");
            frame.setSize(54);
            String displayName = "Done";
            InventoryView inventoryView = this.director.getPlayer().getOpenInventory();
            new GUISlot(this.gui, 54).setItem(Material.GREEN_DYE).setLabel(displayName).onClick(() -> {
                for (ItemStack item : inventoryView.getTopInventory().getContents()) {
                    if (item == null || item.getItemMeta().displayName() != null && PlainTextComponentSerializer.plainText().serialize(item.getItemMeta().displayName()).equals(displayName)) continue;
                    ItemSerialisable itemSerialisable = ItemSerialisable.fromItemStack(item);
                    Integer itemCount = item.getAmount();
                    QuestRegistry.getInstance().updateInventoryItem(this.quest, Map.of(itemSerialisable, itemCount));
                }
                this.gui.clearSlots();
                this.execute();
            });
            this.gui.getResult().draw();
        });
    }

    private boolean createInventorySlot(Map.Entry<ItemSerialisable, Integer> entry) {
        Integer slot = this.gui.getEmptySlot();
        if (slot == 45) {
            return true;
        }
        ItemSerialisable itemSerialisable = entry.getKey();
        Integer predictedAmount = entry.getValue();
        Integer realAmount = Optional.ofNullable(QuestRegistry.getInstance().getInventory(this.quest).get(itemSerialisable)).orElse(0);
        TextComponent.Builder label = (TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)(realAmount.toString() + "x")))).appendSpace()).append((Component)Component.text((String)itemSerialisable.getProperties().getOrDefault(ItemData.getNametagKey(), itemSerialisable.getName())))).appendSpace()).append((Component)Component.text((String)"("));
        if (realAmount == 0) {
            label.append(Component.text((String)"Out of Stock").color((TextColor)NamedTextColor.RED));
        } else if (predictedAmount >= 0) {
            label.append((Component)Component.text((String)"In Stock"));
        } else {
            label.append(Component.text((String)"Not Enough Stock").color((TextColor)NamedTextColor.YELLOW));
        }
        label.append((Component)Component.text((String)")"));
        new GUISlot(this.gui, this.gui.getEmptySlot()).setItem(itemSerialisable).setLabel(label.asComponent()).setDescription(List.of(itemSerialisable.getName())).setGlinting(predictedAmount <= 0);
        return false;
    }

    private void sortInventory() {
        ArrayList<Map.Entry<ItemSerialisable, Integer>> list = new ArrayList<Map.Entry<ItemSerialisable, Integer>>(this.inventory.entrySet());
        list.sort(Map.Entry.comparingByValue());
        LinkedHashMap<ItemSerialisable, Integer> sortedInventory = new LinkedHashMap<ItemSerialisable, Integer>();
        for (Map.Entry entry : list) {
            sortedInventory.put((ItemSerialisable)entry.getKey(), (Integer)entry.getValue());
        }
        this.inventory = sortedInventory;
    }
}

