/*
 * Decompiled with CFR 0.152.
 */
package playerquests.builder.gui.dynamic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import org.bukkit.Material;
import playerquests.builder.gui.component.GUISlot;
import playerquests.builder.gui.data.GUIMode;
import playerquests.builder.gui.dynamic.Dynamicactionselector;
import playerquests.builder.gui.dynamic.GUIDynamic;
import playerquests.builder.gui.function.ChatPrompt;
import playerquests.builder.gui.function.GUIFunction;
import playerquests.builder.gui.function.UpdateScreen;
import playerquests.builder.quest.QuestBuilder;
import playerquests.builder.quest.action.NoneAction;
import playerquests.builder.quest.action.QuestAction;
import playerquests.builder.quest.data.StagePath;
import playerquests.builder.quest.stage.QuestStage;
import playerquests.client.ClientDirector;
import playerquests.utility.singleton.QuestRegistry;

public class Dynamicqueststage
extends GUIDynamic {
    private QuestStage questStage;
    private List<QuestAction<?, ?>> actionKeys;
    private boolean confirmDelete = false;
    private boolean confirmActionKeys = false;
    private QuestBuilder questBuilder;

    public Dynamicqueststage(ClientDirector director, String previousScreen) {
        super(director, previousScreen);
    }

    @Override
    protected void setupCustom() {
        this.questStage = (QuestStage)this.director.getCurrentInstance(QuestStage.class);
        this.questBuilder = (QuestBuilder)this.director.getCurrentInstance(QuestBuilder.class);
    }

    @Override
    protected void executeCustom() {
        this.actionKeys = new ArrayList(this.questStage.getOrderedActions());
        this.gui.getFrame().setTitle(String.format("%s Editor", this.questStage.getLabel()));
        this.gui.getFrame().setSize(27);
        this.createBackButton();
        this.createStageLabelButton();
        this.createStartPointButton();
        this.createDividerSlots();
        if (!this.confirmActionKeys) {
            for (int index : IntStream.range(0, this.actionKeys.size()).toArray()) {
                if (this.createActionButton(index)) break;
            }
            this.confirmActionKeys = true;
        }
        this.createDeleteButton();
        this.createNewActionButton();
    }

    private void createNewActionButton() {
        GUISlot newActionButton = new GUISlot(this.gui, this.gui.getFrame().getSize());
        if (this.questStage.getActions().size() >= 18) {
            newActionButton.setLabel("No More Action Slots");
            newActionButton.setItem(Material.BARRIER);
            return;
        }
        newActionButton.setLabel("Add Action");
        newActionButton.setItem(Material.LIME_DYE);
        newActionButton.onClick(() -> {
            this.questStage.addAction(new NoneAction(this.questStage));
            this.confirmActionKeys = false;
            this.gui.clearSlots();
            this.execute();
        });
    }

    private void createDeleteButton() {
        if (!this.questBuilder.removeStage(this.questStage, true)) {
            new GUISlot(this.gui, this.gui.getFrame().getSize() - 1).setItem(Material.GRAY_DYE).setLabel("Cannot Delete").setDescription(List.of("This stage is connected to other stages and actions."));
            return;
        }
        if (!this.confirmDelete) {
            new GUISlot(this.gui, this.gui.getFrame().getSize() - 1).setItem(Material.RED_DYE).setLabel("Delete Stage").onClick(() -> {
                this.confirmDelete = true;
                this.execute();
            });
            return;
        }
        new GUISlot(this.gui, this.gui.getFrame().getSize() - 1).setItem(Material.RED_WOOL).setLabel("Delete").onClick(() -> {
            if (this.questBuilder.removeStage(this.questStage)) {
                new UpdateScreen(Arrays.asList(this.previousScreen), this.director).execute();
                QuestRegistry.getInstance().submit(this.questBuilder.build());
            }
            QuestRegistry.getInstance().submit(this.questBuilder.build());
        });
    }

    private boolean createActionButton(int index) {
        QuestAction<?, ?> action = this.actionKeys.get(index);
        Integer nextEmptySlot = this.gui.getEmptySlot();
        GUISlot actionSlot = new GUISlot(this.gui, nextEmptySlot);
        String typeString = String.format("Type: %s", action.getName());
        boolean isStartPoint = this.questStage.getStartPoints().stream().anyMatch(p -> p.getStage().equals(this.questStage.getID()) && p.getActions().contains(action.getID()));
        List<String> description = isStartPoint ? List.of(typeString, "Is an entry point") : List.of(typeString);
        actionSlot.setLabel(String.format("%s", action.getLabel())).setDescription(description).setItem(action.getActionStateItem(isStartPoint));
        actionSlot.onClick(() -> {
            if (!this.gui.getFrame().getMode().equals((Object)GUIMode.CLICK)) {
                return;
            }
            this.director.setCurrentInstance(action, QuestAction.class);
            actionSlot.addFunction(new UpdateScreen(Arrays.asList("actioneditor"), this.director)).execute(this.director.getPlayer());
        });
        return false;
    }

    private void createDividerSlots() {
        new GUISlot(this.gui, 2).setItem(Material.BLACK_STAINED_GLASS_PANE);
        new GUISlot(this.gui, 11).setItem(Material.BLACK_STAINED_GLASS_PANE);
        new GUISlot(this.gui, 20).setItem(Material.BLACK_STAINED_GLASS_PANE);
    }

    private void createStartPointButton() {
        List<StagePath> startPoints = this.questStage.getStartPoints();
        new GUISlot(this.gui, 10).setItem(Material.PISTON).setLabel(String.format("%s start point actions", startPoints.isEmpty() ? "Set" : "Change")).onClick(() -> {
            this.director.setCurrentInstance(this.questStage.getQuest());
            this.director.setCurrentInstance(this.questStage.getStartPoints(), List.class);
            new UpdateScreen(List.of("actionselector"), this.director).onFinish((GUIFunction f) -> {
                UpdateScreen updateScreen = (UpdateScreen)f;
                updateScreen.getDynamicGUI().onFinish(g -> {
                    Dynamicactionselector actionSelector = (Dynamicactionselector)g;
                    this.questStage.setStartPoints(actionSelector.getSelectedActions());
                });
            }).execute();
        });
    }

    private void createStageLabelButton() {
        new GUISlot(this.gui, 1).setItem(Material.OAK_SIGN).setLabel(String.format("%s stage label", this.questStage.hasLabel() ? "Change" : "Set")).onClick(() -> new ChatPrompt(Arrays.asList("Type a label to help you remember the stage", "none"), this.director).onFinish((GUIFunction func) -> {
            ChatPrompt function = (ChatPrompt)func;
            String response = function.getResponse();
            this.questStage.setLabel(response);
            this.refresh();
        }).execute());
    }

    private void createBackButton() {
        GUISlot exitButton = new GUISlot(this.gui, 19);
        exitButton.setLabel("Back");
        exitButton.setItem(Material.OAK_DOOR);
        exitButton.addFunction(new UpdateScreen(Arrays.asList("queststages"), this.director));
    }
}

