/*
 * Decompiled with CFR 0.152.
 */
package playerquests.builder.gui.dynamic;

import java.util.Arrays;
import java.util.stream.IntStream;
import org.bukkit.Material;
import playerquests.builder.gui.component.GUISlot;
import playerquests.builder.gui.data.GUIMode;
import playerquests.builder.gui.dynamic.GUIDynamic;
import playerquests.builder.gui.function.UpdateScreen;
import playerquests.builder.quest.QuestBuilder;
import playerquests.builder.quest.stage.QuestStage;
import playerquests.client.ClientDirector;
import playerquests.utility.ChatUtils;
import playerquests.utility.singleton.QuestRegistry;

public class Dynamicqueststages
extends GUIDynamic {
    private QuestBuilder questBuilder;
    private String guiTitle = "Quest Stages";

    public Dynamicqueststages(ClientDirector director, String previousScreen) {
        super(director, previousScreen);
    }

    @Override
    public void setupCustom() {
        this.questBuilder = (QuestBuilder)this.director.getCurrentInstance(QuestBuilder.class);
        this.guiTitle = this.guiTitle + " (" + ChatUtils.shortenString(this.questBuilder.getTitle(), 18) + ")";
    }

    @Override
    public void executeCustom() {
        this.generatePages();
    }

    public void generatePages() {
        this.gui.getFrame().setTitle(this.guiTitle);
        this.gui.getFrame().setSize(Math.min((this.questBuilder.getStages().size() + 20) / 9 * 9, 54));
        this.gui.getResult().minimise();
        this.gui.getResult().open();
        IntStream.iterate(1, n -> n + 9).limit(6L).forEach(divSlot -> {
            new GUISlot(this.gui, divSlot).setItem(Material.BLACK_STAINED_GLASS_PANE);
            new GUISlot(this.gui, divSlot + 1).setItem(Material.BLACK_STAINED_GLASS_PANE);
        });
        GUISlot exitButton = new GUISlot(this.gui, this.gui.getFrame().getSize() - 8);
        exitButton.setLabel("Back");
        exitButton.setItem(Material.OAK_DOOR);
        exitButton.addFunction(new UpdateScreen(Arrays.asList(this.previousScreen), this.director));
        if (this.questBuilder.getStages().size() < 42) {
            new GUISlot(this.gui, this.gui.getFrame().getSize()).setLabel("Add Stage").setItem(Material.LIME_DYE).onClick(() -> {
                this.questBuilder.addStage(new QuestStage(this.questBuilder.build(), this.questBuilder.getStages().isEmpty() ? 0 : Integer.parseInt(this.questBuilder.getStages().getLast().getID().substring(6)) + 1));
                QuestRegistry.getInstance().submit(this.questBuilder.build());
                this.gui.clearSlots();
                this.execute();
            });
        }
        IntStream.range(0, this.questBuilder.getStages().size()).anyMatch(index -> {
            QuestStage stage = this.questBuilder.getStages().get(index);
            Integer nextEmptySlot = this.gui.getEmptySlot();
            GUISlot questSlot = new GUISlot(this.gui, nextEmptySlot);
            questSlot.setItem(Material.DIRT_PATH);
            questSlot.setLabel(stage.getLabel());
            questSlot.onClick(() -> {
                if (!this.gui.getFrame().getMode().equals((Object)GUIMode.CLICK)) {
                    return;
                }
                this.director.setCurrentInstance(this.questBuilder.getQuestPlan().get(stage.getID()));
                new UpdateScreen(Arrays.asList("queststage"), this.director).execute();
            });
            return false;
        });
    }
}

