/*
 * Decompiled with CFR 0.152.
 */
package playerquests.builder.gui.dynamic;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Arrays;
import org.bukkit.Material;
import playerquests.builder.gui.component.GUIFrame;
import playerquests.builder.gui.component.GUISlot;
import playerquests.builder.gui.dynamic.GUIDynamic;
import playerquests.builder.gui.function.UpdateScreen;
import playerquests.builder.quest.QuestBuilder;
import playerquests.client.ClientDirector;
import playerquests.product.Quest;
import playerquests.utility.ChatUtils;
import playerquests.utility.serialisable.ItemSerialisable;

public class Dynamictheirquest
extends GUIDynamic {
    Quest questProduct;

    public Dynamictheirquest(ClientDirector director, String previousScreen) {
        super(director, previousScreen);
    }

    @Override
    protected void setupCustom() {
        this.questProduct = (Quest)this.director.getCurrentInstance(Quest.class);
    }

    @Override
    protected void executeCustom() {
        GUIFrame guiFrame = this.gui.getFrame();
        String questTitle = this.questProduct.getTitle();
        guiFrame.setTitle(String.format("Quest: %s (Shared)", ChatUtils.shortenString(questTitle, 18)));
        new GUISlot(this.gui, 1).setLabel("Back").setItem(Material.OAK_DOOR).addFunction(new UpdateScreen(Arrays.asList(this.previousScreen), this.director));
        new GUISlot(this.gui, 3).setLabel("Clone").setItem(new ItemSerialisable("CHAIN[type:EXPOSED_COPPER]")).onClick(() -> {
            try {
                new QuestBuilder(this.director, Quest.fromJSONString(this.questProduct.toJSONString())).setDirector(this.director);
            }
            catch (JsonProcessingException e) {
                ChatUtils.message("Could not clone this quest, the quest is invalid.").player(this.director.getPlayer()).type(ChatUtils.MessageType.ERROR).send();
            }
            new UpdateScreen(Arrays.asList("questeditor"), this.director).execute();
        });
    }
}

