/*
 * Decompiled with CFR 0.152.
 */
package playerquests.builder.gui.dynamic;

import java.util.List;
import java.util.function.Consumer;
import playerquests.builder.gui.GUIBuilder;
import playerquests.builder.gui.function.GUIFunction;
import playerquests.builder.gui.function.UpdateScreen;
import playerquests.client.ClientDirector;

public abstract class GUIDynamic {
    protected ClientDirector director;
    protected String previousScreen;
    protected boolean wasSetup = false;
    protected GUIBuilder gui;
    protected Consumer<GUIDynamic> onFinish;

    protected GUIDynamic(ClientDirector director, String previousScreen) {
        this.director = director;
        this.previousScreen = previousScreen;
        this.gui = director.getGUI();
    }

    public void setup() {
        this.wasSetup = true;
        this.gui.setScreenName(this.getClass().getSimpleName().split("Dynamic")[1]);
        this.setupCustom();
        this.execute();
    }

    public void execute() {
        if (!this.wasSetup) {
            this.setup();
            return;
        }
        this.executeCustom();
        if (!this.gui.getResult().isOpen()) {
            this.gui.getResult().open();
        } else {
            this.gui.getResult().draw();
        }
    }

    protected abstract void setupCustom();

    protected abstract void executeCustom();

    protected void finish() {
        if (this.onFinish != null) {
            this.onFinish.accept(this);
            this.onFinish = null;
        }
    }

    public GUIDynamic onFinish(Consumer<GUIDynamic> onFinish) {
        this.onFinish = onFinish;
        return this;
    }

    public void refresh() {
        new UpdateScreen(List.of(this.gui.getScreenName()), this.director).onFinish((GUIFunction f) -> {
            UpdateScreen updateScreen = (UpdateScreen)f;
            updateScreen.getDynamicGUI().onFinish(this.onFinish);
        }).execute();
    }
}

